# MySQL Connector/ODBC Driver

You can get the latest stable release from the [MySQL downloads](https://dev.mysql.com/downloads/connector/odbc/).

For detailed information please visit the official [MySQL Connector/ODBC documentation](https://dev.mysql.com/doc/connector-odbc/en/).

Source packages are available from our [github releases page](https://github.com/mysql/mysql-connector-odbc/releases).

## Licensing

Please refer to files README and LICENSE, available in this repository, and [Legal Notices in documentation](https://dev.mysql.com/doc/relnotes/connector-odbc/en/preface.html) for further details.

## Download & Install

MySQL Connector/ODBC can be installed from pre-compiled packages that can be downloaded from the [MySQL downloads page](https://dev.mysql.com/downloads/connector/odbc/).
The process of installing of Connector/ODBC from a binary distribution is described in [MySQL online manuals](https://dev.mysql.com/doc/connector-odbc/en/connector-odbc-installation.html)

### Building from sources

MySQL Connector/ODBC can be installed from the source. Please select the relevant platform in [MySQL online manuals](https://dev.mysql.com/doc/connector-odbc/en/connector-odbc-installation.html)

### GitHub Repository

This repository contains the MySQL Connector/ODBC source code as per latest released version. You should expect to see the same contents here and within the latest released Connector/ODBC package.

## Usage Scenarios

The MySQL Connector/ODBC can be used in a variety of programming languages and applications.
The most popular of them are:

* C and C++ programming using ODBC API
* C++ programming using ADODB objects
* Visual Basic programming using ADODB objects
* Java through JDBC/ODBC bridge
* .NET platform with ADO.NET/ODBC bridge
* PHP, Perl, Python, Ruby, Erlang.
* Office applications through linked tables and Visual Basic integration
* Multitude of other applications supporting ODBC


## Documentation

* [MySQL](http://www.mysql.com/)
* [Connector ODBC Developer Guide](https://dev.mysql.com/doc/connector-odbc/en/)
* [ODBC API Reference MSDN](https://msdn.microsoft.com/en-us/ie/ms714562(v=vs.94))

## Questions/Bug Reports

* [Discussion Forum](https://forums.mysql.com/list.php?37)
* [Slack](https://mysqlcommunity.slack.com)
* [Bugs](https://bugs.mysql.com)

## Contributing

Please see our [guidelines](CONTRIBUTING.md) for contributing to the driver.
