//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// pthread の OS ごとに違う部分を吸収する
//

#pragma once

#include "header.h"
#include <pthread.h>
#if defined(HAVE_SCHED_H)
#include <sched.h>
#endif
#if defined(HAVE_SYS_CPUSET_H)
#include <sys/cpuset.h>
#endif

// cpu{,_}set_t とその関数群の違いを吸収するクラス
#if defined(HAVE_CPUSET_T_P) || defined(HAVE_CPU_SET_T)

// 型は NetBSD/FreeBSD のほうに揃えておく。
#if defined(HAVE_CPU_SET_T) && !defined(HAVE_CPUSET_T)
#define cpuset_t	cpu_set_t
#endif

#define HAVE_MICPUSET 1

class MICPUSet
{
 public:
	MICPUSet();
	~MICPUSet();

	// cpuset_t を返す
	cpuset_t *Get() const { return set; }

	// サイズを返す
	size_t Count() const;

	// CPU #n のビットをセットする
	void Set(uint n);

	// CPU #n のビットを取得する
	bool Get(uint n) const;

 private:
	cpuset_t *set {};
#if !defined(HAVE_CPUSET_CREATE)
	cpuset_t entity {};
#endif
};
#endif // HAVE_CPUSET_T_P || HAVE_CPU_SET_T

#if defined(HAVE_PTHREAD_SETAFFINITY_NP)
extern int PTHREAD_SETAFFINITY(pthread_t, const MICPUSet&);
#endif
extern int PTHREAD_SETNAME(const char *name);
extern std::string PTHREAD_GETNAME(pthread_t thread = pthread_self());
