//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NWS-1750 のキーボードコントローラ(予定地)
//

#pragma once

#include "device.h"

class KBCDevice : public IODevice
{
	using inherited = IODevice;

	// レジスタ
	static const uint32 KEYDATA		= 0;
	static const uint32 KEYSTAT		= 1;
	static const uint32 KEYINTE		= 2;
	static const uint32 KEYRESET	= 3;
	static const uint32 KEYBUZZ		= 4;
	static const uint32 MSDATA		= 5;
	static const uint32 MSINTE		= 6;
	static const uint32 MSRESET		= 7;

 public:
	KBCDevice();
	~KBCDevice() override;

 protected:
	// BusIO インタフェース
	// 何も分からないのでとりあえず適当に折り返しておく
	static const uint32 NPORT = 8;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);
};
