//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

//
// MSX-DOS コマンドラインエミュレータ
//

#pragma once

#include "prom.h"
#include <vector>

class MPU64180Device;
class XPbusDevice;

class MSXDOSDevice : public PROMDevice
{
	using inherited = PROMDevice;

	// データの受け渡し用。
	struct data_t {
		uint8 *data;
		int size;
	};

 public:
	MSXDOSDevice();
	~MSXDOSDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	// MSXDOS コールエミュレーション
	void Syscall();

 private:
	bool LoadBinary(const char *filename);
	void Putc(int ch);

	int cursor_x {};

	std::vector<uint8> filebuf {};

	MPU64180Device *xp {};
	XPbusDevice *xpbus {};
};
