//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構
//

#include "uimessage.h"

/*static*/ UIMessage::Queue UIMessage::queue {};
/*static*/ std::function<void(UIMessage::Queue&)> UIMessage::process {};

// コンストラクタ
UIMessage::UIMessage()
	: UIMessage(ID::NONE, 0)
{
}

// コンストラクタ (ID, argあり)
UIMessage::UIMessage(ID id_, int arg_)
{
	id = id_;
	arg = arg_;
}

/*static*/ void
UIMessage::Attach(const std::function<void(Queue&)>& process_)
{
	process = process_;
	// 溜まっているものを処理する
	process(queue);
}

void
UIMessage::Post()
{
	queue.EnqueueForce(*this);
	if (process) {
		process(queue);
	}
}

/*static*/ void
UIMessage::Post(ID id)
{
	UIMessage(id, 0).Post();
}

/*static*/ void
UIMessage::Post(ID id, int arg)
{
	UIMessage(id, arg).Post();
}
