//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構 (CLI 側)
//

#pragma once

#include "uimessage.h"
#include "autofd.h"
#include <array>
#include <functional>

class CUIMessage
{
	using Func = std::function<void(const UIMessage&)>;
 public:
	// CUIMessage を初期化する
	static int Init();

	// UIMessage を func に接続する
	static void Connect(UIMessage::ID id, Func func);

	// UIMessage を処理する (VM スレッドで呼ばれる)
	static void Process(UIMessage::Queue& queue);

	// UIMessage をディスパッチする (メインスレッドで呼ばれる)
	static void Dispatch(const UIMessage& m);

 private:
	static std::array<Func, UIMessage::ID_MAX> func_table;

	static autofd wpipe;
	static autofd rpipe;
};
