//
// XM6i
// Copyright (C) 2013-2016 isaki@NetBSD.org
//
// for debugging
//

#include <float.h>
#include <stdio.h>
#include <string.h>

#define PRINTF	printf
#define DUMPFP	dumpfp
#define DUMPFPN	dumpfpn

static inline void dumpfp_main(const char *msg, const struct fpn *f)
{
	printf("%s ", msg);
	switch (f->fp_class) {
	 case FPC_SNAN:	printf("FPC_SNAN");	break;
	 case FPC_QNAN: printf("FPC_QNAN"); break;
	 case FPC_ZERO: printf("FPC_ZERO"); break;
	 case FPC_NUM:  printf("FPC_NUM "); break;
	 case FPC_INF:  printf("FPC_INF "); break;
	 default:       printf("unknown%d", f->fp_class); break;
	}
	printf(" %2d %c%08x:%08x:%08x:%d",
		f->fp_exp, f->fp_sign?'-':'+',
		f->fp_mant[0],f->fp_mant[1], f->fp_mant[2],
		f->fp_sticky?1:0);
}

static inline void dumpfp(const char *msg, const struct fpn *f)
{
	dumpfp_main(msg, f);
	printf("\n");
}

static inline void dumpfpn(const char *msg, const struct fpn *f)
{
	dumpfp_main(msg, f);
	printf(" = %.*Lg\n", LDBL_DIG, fp2ldbl(f));
}
