//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// 矩形構造体
//

#pragma once

#include "header.h"

//
// 自前の Rect 構造体
//
struct Rect
{
	int x {};
	int y {};
	int w {};
	int h {};

	Rect() {}

	Rect(int x_, int y_, int w_, int h_) {
		x = x_;
		y = y_;
		w = w_;
		h = h_;
	}

	void SetLTRB(int left, int top, int right, int bottom) {
		x = left;
		y = top;
		w = right - x + 1;
		h = bottom - y + 1;
	}

	int GetRight() const  { return x + w - 1; }
	int GetBottom() const { return y + h - 1; }

	void Offset(int dx, int dy) {
		x += dx;
		y += dy;
	}

	// 点 (px, py) がこの矩形の内側(境界を含む)にあれば true を返す
	bool Contains(int px, int py) const {
		return (x <= px && px < x + w &&
		        y <= py && py < y + h);
	}
};

//
// 自前の Rect<float> 構造体
//
struct RectF
{
	float x {};
	float y {};
	float w {};
	float h {};

	RectF() {}

	RectF(float x_, float y_, float w_, float h_) {
		x = x_;
		y = y_;
		w = w_;
		h = h_;
	}
};
