//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// イベント
//

#include "event.h"
#include "scheduler.h"

// コンストラクタ
Event::Event()
{
}

// コンストラクタ (dev 指定あり)
Event::Event(Device *dev_)
	: Event()
{
	dev = dev_;
}

// デストラクタ
Event::~Event()
{
}

// 名前をセットする
void
Event::SetName(const std::string& val)
{
	name = val;
	if (name.length() > 25) {
		dev->putmsgn("Event Name \"%s\" is too long(%u chars)",
			name.c_str(), (uint)name.length());
		name.resize(25);
	}
}
