//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VirtIO ブロックデバイス
//

#pragma once

#include "virtio_base.h"
#include "diskimage.h"
#include "scsidev.h"

class VirtIOBlockDevice : public VirtIODevice
{
	using inherited = VirtIODevice;

 public:
	VirtIOBlockDevice(uint slot_, uint id_);
	~VirtIOBlockDevice() override;

	bool Init() override;

	// メディアの書き込みモードを返す
	SCSIDisk::RW GetWriteMode() const { return write_mode; }

	// 現在のアクセス状況を返す
	uint32 GetAccessRead() const	{ return access_read; }
	uint32 GetAccessWrite() const	{ return access_write; }

 private:
	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	const char *GetFeatureName(uint feature) const override;

	bool LoadDisk(const std::string& pathname_);

	// ディスクリプタを一つ処理する。
	void ProcessDesc(VirtIOReq&) override;
	uint32 CmdRead(VirtIOReq&, uint64 sector, uint32 datalen);
	uint32 CmdWrite(VirtIOReq&, uint64 sector, uint32 datalen);

	uint id {};					// 識別番号
	std::string pathname {};	// イメージファイルのフルパス
	bool write_ignore {};		// 書き込み無視オプション

	DiskImage image {};			// イメージファイル
	uint32 blocksize {};		// 論理ブロック長
	SCSIDisk::RW write_mode {};	// メディアの書き込みモード

	// アクセスインジケータ (GUI) 用のカウンタ。
	uint32 access_read {};
	uint32 access_write {};
};
