//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// デバッガ (M88xx0 依存部分)
//

#pragma once

#include "debugger_private.h"
#include "mpu88xx0.h"
#include "m88100disasm.h"

class DebuggerMD_m88xx0 : public DebuggerMD
{
	using inherited = DebuggerMD;
 public:
	explicit DebuggerMD_m88xx0(Debugger *parent_);
	~DebuggerMD_m88xx0() override;

	CPUState GetCPUState() const override { return (CPUState)cpu->GetState(); }
	bool IsSuper() const override { return cpu->IsSuper(); }
	bool MMUEnabled() const override;
	busaddr TranslateAddr(busaddr laddr) const override;

	uint32 GetPC() const override { return cpu->GetPPC(); }

	void SetStepOut() override;
	bool IsStepOut() const override;
	bool IsOpStepIn(DebuggerMemoryStream& mem) override;
	uint64 GetRegAddr(const char *name) const override;
	void BackupRegs() override;
	bool ShowRegister(FILE *, const std::vector<std::string>& args) override;
	const HelpMessages& GetHelpListReg() const override;
	const HelpMessages& GetHelpReg() const override;

	bool CheckLEA(uint32 laddr) override {
		bool rv = cpu->lastaddr == laddr;
		cpu->lastaddr = (uint64)-1;	// XXX: ていうかここでクリアはおかしい
		return rv;
	}

	std::string Disassemble(DebuggerMemoryStream& mem) override;
	std::string ParseInst(const std::string&) const override;

 private:
	MPU88xx0Device *cpu {};	// MPU デバイス
	m88200 *cmmu0 {};		// 命令 CMMU
	m88200 *cmmu1 {};		// データ CMMU
	m88100reg prev {};		// 前回のレジスタセットのコピー

	static bool IsBB0(uint32 op);
	static bool IsTB0(uint32 op);
	static bool IsBBTB0(uint32 op);
	static bool IsBB1(uint32 op);
	static bool IsTB1(uint32 op);
	static bool IsBBTB1(uint32 op);
	const char *CondStr(uint32 op);

	static const HelpMessages HelpListReg;
	static const HelpMessages HelpReg;
	bool MatchCMMUCmd(const std::string& cmdname, const char *name, int *);
	void ShowRegMain();
	bool ShowRegCache(FILE *, const std::vector<std::string>& args, int id);
	void ShowRegCacheOverview(m88200 *cmmu);
	void ShowRegCacheSet(m88200 *cmmu, int setidx);
	void ShowRegCtrl();
	void ShowRegFPU();
	void ShowRegOther();

	// cmp 命令後の分岐命令で結果レジスタを表示するため、
	// cmp 命令のデスティネーションレジスタを覚えておく。
	// -1 なら該当しないの意。
	int cmp_rd {};

	const BranchHistory *brhist {};

	uint32 so_r1 {};		// ステップアウト判定用
};
