;
; nono
; Copyright (C) 2025 nono project
; Licensed under nono-license.txt
;

; ASCI の入出力をテストする。
;
; % z80-asm asci.asm 100:asci.z80
; % perl ../util/runcom/z80tocom.pl asci.z80

CNTLA	equ	0
CNTLB	equ	2
STAT	equ	4
TDR	equ	6
RDR	equ	8

	org	0100H
START:
	LD	A,08H	; 9600bps
	LD	C,CNTLB
	CALL	ASCI_OUT

	LD	A,7CH	; RE|TE|CKA1D|EFR|DATA8
	LD	C,CNTLA
	CALL	ASCI_OUT
LOOP:
	LD	C,STAT
	CALL	ASCI_IN_F
	JP	P,LOOP	; loop unless RDRF
	; Get Received char
	LD	C,RDR
	CALL	ASCI_IN
	LD	E,A
	; PUTC でホストに出力
	LD	C,02H
	CALL	0005H
	; エコーバック
	LD	A,E
	LD	C,TDR
	CALL	ASCI_OUT

	JR	LOOP

; OUT0 (C),A をする (その際 CHANNEL を見る)
; IN:  A = 出力データ
;      C = I/O アドレス(の CH0 側)
; OUT: -
; USE: -
ASCI_OUT:
	PUSH	BC
	PUSH	AF
	LD	A,(CHANNEL)
	ADD	A,C
	LD	C,A
	LD	B,00H
	POP	AF
	defb	0EDH, 79H	; OUT (C),A
	POP	BC
	RET

; IN0 A,(C) をする (その際 CHANNEL を見る)
; IN:  C = I/O アドレス(の CH0 側)
; OUT: A = 入力データ
; USE: F は不定
ASCI_IN:
	PUSH	BC
	LD	A,(CHANNEL)
	ADD	A,C
	LD	C,A
	LD	B,00H
	defb	0EDH, 78H	; IN A,(C)
	POP	BC
	RET

; IN0 F,(C) をする (その際 CHANNEL を見る)
; IN:  C = I/O アドレス(の CH0 側)
; OUT: F = 入力データ
; USE: A
ASCI_IN_F:
	PUSH	BC
	LD	A,(CHANNEL)
	ADD	A,C
	LD	C,A
	LD	B,00H
	defb	0EDH,70H	; IN F,(C)
	POP	BC
	RET

CHANNEL:
	defb	01H		; 使用するチャンネル

; vi:set ts=8:
