//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートのメイン画面コンソール入出力ドライバ
//

#pragma once

#include "comdriver.h"
#include "autofd.h"

class ConsoleDevice;

class COMDriverConsole : public COMDriver
{
	using inherited = COMDriver;
 public:
	explicit COMDriverConsole(HostDevice *hostdev_);
	~COMDriverConsole() override;

	bool InitDriver(bool startup) override;
	int Read() override;
	void Write(uint32 data) override;

	void EnqueueChar(uint charcode);

 private:
	// VM側 (UI スレッド) からの連絡用。
	autofd rxpipe {};
	autofd txpipe {};

	ConsoleDevice *console {};
};
