//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートのホストデバイス
//

#pragma once

#include "hostdevice.h"
#include "comdriver.h"
#include "spscqueue.h"

class ConfigItem;

class HostCOMDevice : public HostDevice
{
	using inherited = HostDevice;
	using COMQueue = SPSCQueue<uint8, 1024>;

	// 統計情報
	struct stat_t {
		uint64 tx_bytes;			// VM からの送信バイト数
		uint64 rx_bytes;			// VM が受信したバイト数
		uint64 txqfull_bytes;		// TxQ が一杯で落としたバイト数
		uint64 rxqfull_bytes;		// RxQ が一杯で落としたバイト数
		uint64 write_bytes;			// ホストへの書き出しバイト数
		uint64 read_bytes;			// ホストからの読み込みバイト数

		uint txq_peak;				// キューのおおよその最大使用量
		uint rxq_peak;				// キューのおおよその最大使用量
	};

 public:
	HostCOMDevice(Device *parent_, int n, const std::string& portname_);
	~HostCOMDevice() override;

	void SetLogLevel(int loglevel_) override;
	bool Create2() override;

	void Dispatch(int udata) override;
	bool Tx(uint32 data);
	uint32 Rx();

	// ドライバ名を返す。
	const std::string GetDriverName();

 private:
	bool SelectDriver(bool startup) override;
	void CreateNone();
	void CreateStdio(const ConfigItem&, const std::string& key);
	void CreateTCP();
	void CreateConsole(const ConfigItem&);

	int Read() override;
	void Write() override;

	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	// キュー
	COMQueue txq {};
	COMQueue rxq {};

	std::unique_ptr<COMDriver> driver {};

	// 統計情報
	struct stat_t stat {};

	Monitor *monitor {};
};
