//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// ホストネットワークの AF_PACKET ドライバ
// (Linux 専用)
//

#pragma once

#include "netdriver.h"
#include <sys/socket.h>
#include <netpacket/packet.h>
#include <net/ethernet.h>

class NetDriverAFPacket : public NetDriver
{
	using inherited = NetDriver;
 public:
	NetDriverAFPacket(HostDevice *hostdev_, const std::string& ifname_);
	~NetDriverAFPacket() override;

	bool InitDriver(bool startup) override;
	int Read(NetPacket *p) override;
	void Write(const void *buf, int buflen) override;

	void MonitorUpdateMD(TextScreen&, int y) override;

 private:
	void Close();

	// インタフェース番号を返す
	int SelectInterface();

	sockaddr_ll sll {};
};
