//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ROM の基本クラス
//

#pragma once

#include "device.h"

class ROMDevice : public IODevice
{
	using inherited = IODevice;
 public:
	explicit ROMDevice(uint objid_);
	~ROMDevice() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

	// ファイル名を取得。なければ NULL。
	const char *GetFilename() const;

	// アクセスウェイト [clock] を取得/設定
	void SetWait(uint32 wait_);

 protected:
	bool AllocROM(uint len, uint8 fill);
	bool LoadROM(const char *name, uint size);

	// Read()/Peek1() がアクセスするメモリ領域をさすポインタ。
	const uint8 *mem {};

	// アクセスマスク。
	// LUNA の PROM のように、この ROM の折り返しミラーが見える構造なら
	// このアクセスマスクを設定すること。
	// X680x0 の各 ROM などはミラーが不要なのでコンストラクタで初期化される
	// 0xffffffff のままでよい。
	uint32 mask {};

	// ファイル名
	std::string filename {};

	// イメージ
	// (ファイルから読み込んだ内容、あるいは自分で作ったバッファ)
	std::unique_ptr<uint8[]> imagebuf {};

	// ライトアクセス時の動作 (Write*() の戻り値)。
	// 派生クラスが指定すること。
	busdata write_op {};

	// アクセスウェイト
	busdata wait {};
};
