//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// VM (NEWS)
//

#include "vm_news.h"
#include "config.h"
#include "console.h"
#include "dipsw.h"
#include "mainbus_news.h"
#include "mpu680x0.h"
#include "newsfb.h"
#include "power.h"
#include "renderer.h"

// コンストラクタ
VM_NEWS::VM_NEWS()
	: inherited("NWS-1750")
{
	// 機種固有パラメータ
	// 実時間に同期したほうが便利。
	gConfig->SetDefault("clock-sync", "real");
	// 仮想コンソール。
	gConfig->SetDefault("hostcom0-driver", "console");
	// MPU 種別。
	gConfig->SetDefault("mpu-type", "68030");
	// MPU クロックの初期値は機種ごとに異なる。単位は MHz
	gConfig->SetDefault("mpu-clock", 25);
	// RAM 初期値は?
	gConfig->SetDefault("ram-size", 16);
	// RTC epoch は 1900年。
	gConfig->SetDefault("rtc-epoch-year", 1900);

	NEWDV(Power, new PowerDevice());
	NEWDV(MPU, NewMPU680x0Device());
	NEWDV(Mainbus, new NewsMainbus());
	NEWDV(Console, new ConsoleDevice());
	NEWDV(Keyboard, new ConsoleKeyboard());
	NEWDV(Renderer, new ConsoleRenderer());
	NEWDV(Newsfb, new NewsfbDevice());
	NEWDV(Dipsw, new NewsDipswDevice());

	// バーストアクセスがあるかどうかは分からないが
	// Mainbus が LUNA-I と共通なので一応揃えておく。
	auto mpu680x0 = GetMPU680x0Device(pMPU.get());
	if (mpu680x0) {
		mpu680x0->EnableBurstAccess(true);
	}
}

// デストラクタ
VM_NEWS::~VM_NEWS()
{
}
