//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// サウンドのホストデバイス
//

#pragma once

#include "hostdevice.h"
#include "spscqueue.h"

class SoundDriver;

class HostSoundDevice : public HostDevice
{
	using inherited = HostDevice;
	using PlayQueue = SPSCQueue<const int16 *, 4>;
	friend class SoundDriver;

	// 統計情報
	struct stat_t {
		uint64 write_blk;
	};

 public:
	HostSoundDevice(Device *parent_);
	~HostSoundDevice() override;

	void SetLogLevel(int loglevel_) override;
	bool Create2() override;

	// ドライバ名を返す。
	const std::string& GetDriverName();

	// 再生(を指示)
	bool Play(const int16 *blk);

	// 出力キューが空なら true を返す。
	bool IsQEmpty() const	{ return playq.Length() == 0; }

 private:
	bool SelectDriver(bool startup) override;
	void CreateNone();
	void CreateWav();
	void CreateNetBSD();
	void CreateSndIO();
	void CreateALSA();

	// 外部への書き出し(再生)
	void Write() override;

	// 外部からの読み込み (未対応)
	int Read() override;

	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	std::unique_ptr<SoundDriver> driver {};

	// ホストの(入)出力周波数 [Hz]
	uint32 freq {};

	// 1ブロックのバイト数
	size_t bytes_per_blk {};

	// キュー
	PlayQueue playq {};

	// 統計情報
	struct stat_t stat {};

	Monitor *monitor {};
};
