//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// サウンドの ALSA ドライバ
//

#pragma once

#include "sounddriver.h"
#include <alsa/asoundlib.h>

class SoundDriverALSA : public SoundDriver
{
	using inherited = SoundDriver;
 public:
	explicit SoundDriverALSA(HostDevice *hostdev_);
	~SoundDriverALSA() override;

	bool InitDriver(bool startup = true) override;

	void Write(const int16 *) override;

	void MonitorUpdateMD(TextScreen&, int y) override;

 private:
	void Close();

	snd_pcm_t *pcm {};

	std::string device {};
};
