//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// ROM エミュレーションデバイスの基本クラス
//

#pragma once

#include "rom.h"

class ROMEmuDevice : public ROMDevice
{
	using inherited = ROMDevice;
 public:
	explicit ROMEmuDevice(uint objid_);
	~ROMEmuDevice() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;

 protected:
	virtual uint64 ReadROMIO(busaddr addr);
	virtual bool WriteROMIO(busaddr addr, uint32 data);
};
