//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// スプライトコントローラ
//

#pragma once

#include "device.h"

class SpriteDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xeb0000;

	struct sprite_scroll {
		uint16 xpos;
		uint16 ypos;
		uint16 col;
		uint16 prw;
	} __attribute__((__packed__));

	struct sprite_ctrl {
		struct sprite_scroll sprite[128];

		uint16 bg0x;
		uint16 bg0y;
		uint16 bg1x;
		uint16 bg1y;
		uint16 bgctrl;

		uint16 htotal;		// 水平トータル
		uint16 hdisp;		// 水平表示位置
		uint16 vdisp;		// 垂直表示位置
		uint16 res;			// 解像度
	};

 public:
	SpriteDevice();
	~SpriteDevice() override;

	bool Init() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

 private:
	busdata Get16(uint32 addr) const;
	busdata Set16(uint32 addr, uint32 data);

	struct sprite_ctrl reg {};
	std::unique_ptr<uint8[]> mem {};
};
