//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// TAS ポート
//

#include "tas.h"

// コンストラクタ
TASDevice::TASDevice()
	: inherited(OBJ_TAS)
{
}

// デストラクタ
TASDevice::~TASDevice()
{
}

// リセット
void
TASDevice::ResetHard(bool poweron)
{
	// 初期値は 0 らしい (LUNA-88K PROM 1.20 がそう期待している)。
	// いつリセットされるかは分からないけど、さすがにリセットされるだろう。
	tas = 0;
}

// XXX: RMW サイクルが発行される前提のレジスタだが
// まだ CPU から RMW サイクルを示す信号線が出ていない。

busdata
TASDevice::ReadPort(uint32 offset)
{
	busdata data;

	data = (uint32)tas.load();
	putlog(2, "Read 0x%02x", data.Data());
	data |= BusData::Size1;
	return data;
}

busdata
TASDevice::WritePort(uint32 offset, uint32 data)
{
	// data は bit7 のみ有効。data の bit7 は
	// LUNA-I では B 接続なので、各バイトの bit7 に相当、
	// LUNA-88K では BFFF 接続なので bit31 に相当。
	// 最上位ビット以外のビットは「不定」。
	tas = data;
	putlog(1, "Write 0x%02x", data);

	busdata r = BusData::Size1;
	return r;
}

busdata
TASDevice::PeekPort(uint32 offset)
{
	return (uint32)tas.load();
}

bool
TASDevice::PokePort(uint32 offset, uint32 data)
{
	return false;
}
