//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// TVRAM
//

#pragma once

#include "planevram.h"

class VideoCtlrDevice;

class TVRAMDevice : public PlaneVRAMDevice
{
	using inherited = PlaneVRAMDevice;

	static const uint32 baseaddr = 0xe00000;

	// プレーン数は4枚固定
	static const uint NPLANE = 4;

	struct tvram {
		bool sa;				// 同時アクセス
		bool ap[NPLANE];		// 同時アクセスプレーン
		bool cp[NPLANE];		// ラスターコピー対象
		bool men;				// アクセスマスクイネーブル
		uint16 mask;			// アクセスマスク
	};

 public:
	TVRAMDevice();
	~TVRAMDevice() override;

	bool Init() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	void UpdateInfo(TextScreen&, int x, int y) const override;

	void SetAccessPlane(uint16 data);
	void SetAccessMask(uint16 data);
	void SetScrollX(int x);
	void SetScrollY(int y);
	void RasterCopy(uint src_ras, uint dst_ras);

 private:
	// アドレスデコーダ
	uint32 Decoder(uint32 addr) const;

	void Set8(uint32 offset, uint32 poffset, uint32 data, uint32 mask);
	void Set16(uint32 offset, uint32 poffset, uint32 data, uint32 mask);
	inline void SetDirty(uint32 offset);

	// X 方向にはみ出したときに対応する仮想画面の Y 座標を返す。
	int GetWrapY(int y) const override;

	struct tvram tvram {};

	VideoCtlrDevice *videoctlr {};

	static const busdata wait;
};

static inline TVRAMDevice *GetTVRAMDevice() {
	return Object::GetObject<TVRAMDevice>(OBJ_PLANEVRAM);
}
