//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// スレッドモニタ
//

#pragma once

#include "wxsubwindow.h"
#include "wxtextpanel.h"

struct ThreadInfo;
class ThreadManager;

class WXThreadMonitorPanel : WXTextPanel
{
	using inherited = WXTextPanel;

 public:
	explicit WXThreadMonitorPanel(wxWindow *parent);
	~WXThreadMonitorPanel() override;

	void FontChanged() override;
	void Draw() override;

 private:
	void OnTimer(wxTimerEvent&);
	void DrawGraph(uint x, uint y, uint w, uint h, const ThreadInfo&);

	bool redraw_all {};

	uint nthreads {};

	// 最も長いスレッド名の長さ。
	uint maxnamelen {};

	wxTimer timer {};

	ThreadManager *thman {};

	wxDECLARE_EVENT_TABLE();
};

class WXThreadMonitorWindow : public WXSubWindow
{
	using inherited = WXSubWindow;

 public:
	explicit WXThreadMonitorWindow(wxWindow *parent);
	~WXThreadMonitorWindow() override;
};
