<?php
/*
 * nono
 * Copyright (C) 2020 nono project
 * Licensed under nono-license.txt
 */

$nono_ver = "@version@";
$nono_date = "@date@";

function get_version()
{
	global $nono_ver;
	global $nono_date;

	$fp = fopen("../lib/nono.h", "r");
	if ($fp !== false) {
		while (($buf = fgets($fp)) !== false) {
			if (preg_match("/NONO_MAJOR_VER\s+\((\d+)\)/", $buf, $m)) {
				$nono_major = $m[1];
			}
			if (preg_match("/NONO_MINOR_VER\s+\((\d+)\)/", $buf, $m)) {
				$nono_minor = $m[1];
			}
			if (preg_match("/NONO_PATCH_VER\s+\((\d+)\)/", $buf, $m)) {
				$nono_patch = $m[1];
			}
			if (preg_match("/NONO_DATE\s+\"([^\"]+)\"/", $buf, $m)) {
				$nono_date = $m[1];
			}
		}
		fclose($fp);

		$nono_ver = "${nono_major}.${nono_minor}.${nono_patch}";
	}
}

function print_head_common()
{
	print <<<__EOM__
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<style type="text/css">
/* https://jfly.uni-koeln.de/colorset/ */

:root {
	--blue:			rgb(  0,  90, 255);
	--brown:		rgb(128,  64,   0);
	--green:		rgb(  3, 175, 122);
	--grey:			rgb(132, 145, 158);
	--cream:		rgb(255, 255, 128);
	--yellow-green:	rgb(216, 242,  85);
	--light-pink:	rgb(255, 202, 191);
	--light-green:	rgb(119, 217, 168);
	--light-grey:	rgb(200, 200, 203);

	--bg-grey:		rgb(220, 220, 223);
}
body {
	background-color: var(--bg-grey);
}
q {
	color: var(--brown);
}
q:before {
	content: "[";
}
q:after {
	content: "]";
}
dt.dt-indent {
	padding-left: 1ex;
}
.h4 {
	font-weight: bold;
	font-size: 110%;
}
.h5 {
	font-weight: bold;
	padding-left: 1ex;
}
.main {
	margin-left: 2em;
}
.main1 {
	margin-left: 1em;
}
.cons {
	background-color: black;
	color: white;
}
.file {
	background-color: white;
	color: black;
}
.strike {
	color: var(--grey);
}
.strike > q {
	color: var(--grey);
}
.new {
	background-color: var(--light-green);
}
.new > q {
	background-color: var(--light-green);
}
</style>

__EOM__;
}

function linkto_str($to, $msg)
{
	$str = "<a href=\"{$to}.html\">{$msg}</a>";
	// ブラウザから見てる時だけ .php へのリンクを貼る
	if (isset($_SERVER["HTTP_HOST"])) {
		$str .= "(<a href=\"{$to}.php\">{$to}.php</a>)";
	}
	return $str;
}

function linkto($to, $msg)
{
	print linkto_str($to, $msg);
}
?>
