//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 時刻取得
//

// std::chrono は読めないので極力ここに閉じ込める。
// 所要実時間の計測は stopwatch.h 参照。

#pragma once

#include "header.h"
#include <chrono>

// ホストの現在の UNIX 時刻を [usec] 単位で取得する。
inline uint64
get_hosttime_usec()
{
	using namespace std::chrono;
	auto now = system_clock::now().time_since_epoch();
	auto usec = duration_cast<microseconds>(now).count();
	return static_cast<uint64>(usec);
}

// ホストの現在の UNIX 時刻を [sec] 単位で取得する。
inline uint64
get_hosttime_sec()
{
	using namespace std::chrono;
	auto now = system_clock::now().time_since_epoch();
	auto sec = duration_cast<seconds>(now).count();
	return static_cast<uint64>(sec);
}
