//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// nono の基本ヘッダ
//

#pragma once

#include "header.h"

#define NONO_MAJOR_VER	(1)
#define NONO_MINOR_VER	(6)
#define NONO_PATCH_VER	(4)
#define NONO_DATE		"2025/12/08"

// パニック (PC を表示しない)
#define PANIC(...)	panic_func(__PRETTY_FUNCTION__, __VA_ARGS__)
[[noreturn]] extern void panic_func(const char *funcname, const char *fmt, ...)
	__printflike(2, 3);

// VM 用パニック (PC を表示する)
#define VMPANIC(...) vmpanic_func(__PRETTY_FUNCTION__, __VA_ARGS__)
[[noreturn]] extern void vmpanic_func(const char *funcname, const char *fmt,
	...) __printflike(2, 3);
