	 case (0x0000 >> 6):
		// %0000_000000_mmmrrr	ORI.B #<imm>,<ea>
		// %0000_000000_111100	ORI.B #<imm>,CCR
		OP_FUNC(ori_b);
		break;
	 case (0x0040 >> 6):
		// %0000_000001_mmmrrr	ORI.W #<imm>,<ea>
		// %0000_000001_111100	ORI.W #<imm>,SR
		OP_FUNC(ori_w);
		break;
	 case (0x0080 >> 6):
		// %0000_000010_mmmrrr	ORI.L #<imm>,<ea>
		OP_FUNC(ori_l);
		break;
	 case (0x00c0 >> 6):
		// %0000_000011_mmmrrr	CMP2/CHK2.B <ea>,Rn
		OP_FUNC(cmp2chk2_b);
		break;
	 case (0x0100 >> 6):
	 case (0x0300 >> 6):
	 case (0x0500 >> 6):
	 case (0x0700 >> 6):
	 case (0x0900 >> 6):
	 case (0x0b00 >> 6):
	 case (0x0d00 >> 6):
	 case (0x0f00 >> 6):
		// %0000_xxx100_mmmrrr	BTST.B Dx,<ea>
		// %0000_xxx100_000yyy	BTST.L Dx,Dy
		// %0000_xxx100_001yyy	MOVEP.W (d,Ay),Dx
		OP_FUNC(btst_dn_ea);
		break;
	 case (0x0140 >> 6):
	 case (0x0340 >> 6):
	 case (0x0540 >> 6):
	 case (0x0740 >> 6):
	 case (0x0940 >> 6):
	 case (0x0b40 >> 6):
	 case (0x0d40 >> 6):
	 case (0x0f40 >> 6):
		// %0000_xxx101_mmmrrr	BCHG.B Dx,<ea>
		// %0000_xxx101_000yyy	BCHG.L Dx,Dy
		// %0000_xxx101_001yyy	MOVEP.L (d,Ay),Dx
		OP_FUNC(bchg_dn_ea);
		break;
	 case (0x0180 >> 6):
	 case (0x0380 >> 6):
	 case (0x0580 >> 6):
	 case (0x0780 >> 6):
	 case (0x0980 >> 6):
	 case (0x0b80 >> 6):
	 case (0x0d80 >> 6):
	 case (0x0f80 >> 6):
		// %0000_xxx110_mmmrrr	BCLR.B Dx,<ea>
		// %0000_xxx110_000yyy	BCLR.L Dx,Dy
		// %0000_xxx110_001yyy	MOVEP.W Dx,(d,Ay)
		OP_FUNC(bclr_dn_ea);
		break;
	 case (0x01c0 >> 6):
	 case (0x03c0 >> 6):
	 case (0x05c0 >> 6):
	 case (0x07c0 >> 6):
	 case (0x09c0 >> 6):
	 case (0x0bc0 >> 6):
	 case (0x0dc0 >> 6):
	 case (0x0fc0 >> 6):
		// %0000_xxx111_mmmrrr	BSET.B Dx,<ea>
		// %0000_xxx111_000yyy	BSET.L Dx,Dy
		// %0000_xxx111_001yyy	MOVEP.L Dx,(d,Ay)
		OP_FUNC(bset_dn_ea);
		break;
	 case (0x0200 >> 6):
		// %0000_001000_mmmrrr	ANDI.B #<imm>,<ea>
		// %0000_001000_111100	ANDI.B #<imm>,CCR
		OP_FUNC(andi_b);
		break;
	 case (0x0240 >> 6):
		// %0000_001001_mmmrrr	ANDI.W #<imm>,<ea>
		// %0000_001001_111100	ANDI.W #<imm>,SR
		OP_FUNC(andi_w);
		break;
	 case (0x0280 >> 6):
		// %0000_001010_mmmrrr	ANDI.L #<imm>,<ea>
		OP_FUNC(andi_l);
		break;
	 case (0x02c0 >> 6):
		// %0000_001011_mmmrrr	CMP2/CHK2.W <ea>,Rn
		OP_FUNC(cmp2chk2_w);
		break;
	 case (0x0400 >> 6):
		// %0000_010000_mmmrrr	SUBI.B #<imm>,<ea>
		OP_FUNC(subi_b);
		break;
	 case (0x0440 >> 6):
		// %0000_010001_mmmrrr	SUBI.W #<imm>,<ea>
		OP_FUNC(subi_w);
		break;
	 case (0x0480 >> 6):
		// %0000_010010_mmmrrr	SUBI.L #<imm>,<ea>
		OP_FUNC(subi_l);
		break;
	 case (0x04c0 >> 6):
		// %0000_010011_mmmrrr	CMP2/CHK2.L <ea>,Rn
		OP_FUNC(cmp2chk2_l);
		break;
	 case (0x0600 >> 6):
		// %0000_011000_mmmrrr	ADDI.B #<imm>,<ea>
		OP_FUNC(addi_b);
		break;
	 case (0x0640 >> 6):
		// %0000_011001_mmmrrr	ADDI.W #<imm>,<ea>
		OP_FUNC(addi_w);
		break;
	 case (0x0680 >> 6):
		// %0000_011010_mmmrrr	ADDI.L #<imm>,<ea>
		OP_FUNC(addi_l);
		break;
	 case (0x06c0 >> 6):
		// %0000_011011_mmmrrr	CALLM #<imm>,<ea>
		// %0000_011011_00nnnn	RTM Rn
		OP_FUNC(callm);
		break;
	 case (0x0800 >> 6):
		// %0000_100000_mmmrrr	BTST.B #<imm>,<ea>
		// %0000_100000_000yyy	BTST.L #<imm>,Dy
		OP_FUNC(btst_imm_ea);
		break;
	 case (0x0840 >> 6):
		// %0000_100001_mmmrrr	BCHG.B #<imm>,<ea>
		// %0000_100001_000yyy	BCHG.L #<imm>,Dy
		OP_FUNC(bchg_imm_ea);
		break;
	 case (0x0880 >> 6):
		// %0000_100010_mmmrrr	BCLR.B #<imm>,<ea>
		// %0000_100010_000yyy	BCLR.L #<imm>,Dy
		OP_FUNC(bclr_imm_ea);
		break;
	 case (0x08c0 >> 6):
		// %0000_100011_mmmrrr	BSET.B #<imm>,<ea>
		// %0000_100011_000yyy	BSET.L #<imm>,Dy
		OP_FUNC(bset_imm_ea);
		break;
	 case (0x0a00 >> 6):
		// %0000_101000_mmmrrr	EORI.B #<imm>,<ea>
		// %0000_101000_111100	EORI.B #<imm>,CCR
		OP_FUNC(eori_b);
		break;
	 case (0x0a40 >> 6):
		// %0000_101001_mmmrrr	EORI.W #<imm>,<ea>
		// %0000_101001_111100	EORI.W #<imm>,SR
		OP_FUNC(eori_w);
		break;
	 case (0x0a80 >> 6):
		// %0000_101010_mmmrrr	EORI.L #<imm>,<ea>
		OP_FUNC(eori_l);
		break;
	 case (0x0ac0 >> 6):
		// %0000_101011_mmmrrr	CAS.B Dc,Du,<ea>
		OP_FUNC(cas_b);
		break;
	 case (0x0c00 >> 6):
		// %0000_110000_mmmrrr	CMPI.B #<imm>,<ea>
		OP_FUNC(cmpi_b);
		break;
	 case (0x0c40 >> 6):
		// %0000_110001_mmmrrr	CMPI.W #<imm>,<ea>
		OP_FUNC(cmpi_w);
		break;
	 case (0x0c80 >> 6):
		// %0000_110010_mmmrrr	CMPI.L #<imm>,<ea>
		OP_FUNC(cmpi_l);
		break;
	 case (0x0cc0 >> 6):
		// %0000_110011_mmmrrr	CAS.W Dc,Du,<ea>
		// %0000_110011_111100	CAS2.W Dc1:Dc2,Du1:Du2,(Rn1):(Rn2)
		OP_FUNC(cas_w);
		break;
	 case (0x0e00 >> 6):
		// %0000_111000_mmmrrr	MOVES.B <ea>,Rn
		// %0000_111000_mmmrrr	MOVES.B Rn,<ea>
		OP_FUNC(moves_b);
		break;
	 case (0x0e40 >> 6):
		// %0000_111001_mmmrrr	MOVES.W <ea>,Rn
		// %0000_111001_mmmrrr	MOVES.W Rn,<ea>
		OP_FUNC(moves_w);
		break;
	 case (0x0e80 >> 6):
		// %0000_111010_mmmrrr	MOVES.L <ea>,Rn
		// %0000_111010_mmmrrr	MOVES.L Rn,<ea>
		OP_FUNC(moves_l);
		break;
	 case (0x0ec0 >> 6):
		// %0000_111011_mmmrrr	CAS.L Dc,Du,<ea>
		// %0000_111011_111100	CAS2.L Dc1:Dc2,Du1:Du2,(Rn1):(Rn2)
		OP_FUNC(cas_l);
		break;
	 case (0x1000 >> 6):
	 case (0x1200 >> 6):
	 case (0x1400 >> 6):
	 case (0x1600 >> 6):
	 case (0x1800 >> 6):
	 case (0x1a00 >> 6):
	 case (0x1c00 >> 6):
	 case (0x1e00 >> 6):
		// %0001_xxx000_mmmrrr	MOVE.B <ea>,Dx
		OP_FUNC(move_b_ea_dn);
		break;
	 case (0x1080 >> 6):
	 case (0x1280 >> 6):
	 case (0x1480 >> 6):
	 case (0x1680 >> 6):
	 case (0x1880 >> 6):
	 case (0x1a80 >> 6):
	 case (0x1c80 >> 6):
	 case (0x1e80 >> 6):
		// %0001_xxx010_mmmrrr	MOVE.B <ea>,(Ax)
		OP_FUNC(move_b_ea_anin);
		break;
	 case (0x10c0 >> 6):
	 case (0x12c0 >> 6):
	 case (0x14c0 >> 6):
	 case (0x16c0 >> 6):
	 case (0x18c0 >> 6):
	 case (0x1ac0 >> 6):
	 case (0x1cc0 >> 6):
	 case (0x1ec0 >> 6):
		// %0001_xxx011_mmmrrr	MOVE.B <ea>,(Ax)+
		OP_FUNC(move_b_ea_anpi);
		break;
	 case (0x1100 >> 6):
	 case (0x1300 >> 6):
	 case (0x1500 >> 6):
	 case (0x1700 >> 6):
	 case (0x1900 >> 6):
	 case (0x1b00 >> 6):
	 case (0x1d00 >> 6):
	 case (0x1f00 >> 6):
		// %0001_xxx100_mmmrrr	MOVE.B <ea>,-(Ax)
		OP_FUNC(move_b_ea_anpd);
		break;
	 case (0x1140 >> 6):
	 case (0x1340 >> 6):
	 case (0x1540 >> 6):
	 case (0x1740 >> 6):
	 case (0x1940 >> 6):
	 case (0x1b40 >> 6):
	 case (0x1d40 >> 6):
	 case (0x1f40 >> 6):
		// %0001_xxx101_mmmrrr	MOVE.B <ea>,d16(Ax)
		OP_FUNC(move_b_ea_andi);
		break;
	 case (0x1180 >> 6):
	 case (0x1380 >> 6):
	 case (0x1580 >> 6):
	 case (0x1780 >> 6):
	 case (0x1980 >> 6):
	 case (0x1b80 >> 6):
	 case (0x1d80 >> 6):
	 case (0x1f80 >> 6):
		// %0001_xxx110_mmmrrr	MOVE.B <ea>,(Ax,IX)
		OP_FUNC(move_b_ea_anix);
		break;
	 case (0x11c0 >> 6):
		// %0001_000111_mmmrrr	MOVE.B <ea>,Abs.W
		OP_FUNC(move_b_ea_absw);
		break;
	 case (0x13c0 >> 6):
		// %0001_001111_mmmrrr	MOVE.B <ea>,Abs.L
		OP_FUNC(move_b_ea_absl);
		break;
	 case (0x2000 >> 6):
	 case (0x2200 >> 6):
	 case (0x2400 >> 6):
	 case (0x2600 >> 6):
	 case (0x2800 >> 6):
	 case (0x2a00 >> 6):
	 case (0x2c00 >> 6):
	 case (0x2e00 >> 6):
		// %0010_xxx000_mmmrrr	MOVE.L <ea>,Dx
		OP_FUNC(move_l_ea_dn);
		break;
	 case (0x2040 >> 6):
	 case (0x2240 >> 6):
	 case (0x2440 >> 6):
	 case (0x2640 >> 6):
	 case (0x2840 >> 6):
	 case (0x2a40 >> 6):
	 case (0x2c40 >> 6):
	 case (0x2e40 >> 6):
		// %0010_xxx001_mmmrrr	MOVEA.L <ea>,Ax
		OP_FUNC(movea_l);
		break;
	 case (0x2080 >> 6):
	 case (0x2280 >> 6):
	 case (0x2480 >> 6):
	 case (0x2680 >> 6):
	 case (0x2880 >> 6):
	 case (0x2a80 >> 6):
	 case (0x2c80 >> 6):
	 case (0x2e80 >> 6):
		// %0010_xxx010_mmmrrr	MOVE.L <ea>,(Ax)
		OP_FUNC(move_l_ea_anin);
		break;
	 case (0x20c0 >> 6):
	 case (0x22c0 >> 6):
	 case (0x24c0 >> 6):
	 case (0x26c0 >> 6):
	 case (0x28c0 >> 6):
	 case (0x2ac0 >> 6):
	 case (0x2cc0 >> 6):
	 case (0x2ec0 >> 6):
		// %0010_xxx011_mmmrrr	MOVE.L <ea>,(Ax)+
		OP_FUNC(move_l_ea_anpi);
		break;
	 case (0x2100 >> 6):
	 case (0x2300 >> 6):
	 case (0x2500 >> 6):
	 case (0x2700 >> 6):
	 case (0x2900 >> 6):
	 case (0x2b00 >> 6):
	 case (0x2d00 >> 6):
	 case (0x2f00 >> 6):
		// %0010_xxx100_mmmrrr	MOVE.L <ea>,-(Ax)
		OP_FUNC(move_l_ea_anpd);
		break;
	 case (0x2140 >> 6):
	 case (0x2340 >> 6):
	 case (0x2540 >> 6):
	 case (0x2740 >> 6):
	 case (0x2940 >> 6):
	 case (0x2b40 >> 6):
	 case (0x2d40 >> 6):
	 case (0x2f40 >> 6):
		// %0010_xxx101_mmmrrr	MOVE.L <ea>,d16(Ax)
		OP_FUNC(move_l_ea_andi);
		break;
	 case (0x2180 >> 6):
	 case (0x2380 >> 6):
	 case (0x2580 >> 6):
	 case (0x2780 >> 6):
	 case (0x2980 >> 6):
	 case (0x2b80 >> 6):
	 case (0x2d80 >> 6):
	 case (0x2f80 >> 6):
		// %0010_xxx110_mmmrrr	MOVE.L <ea>,(Ax,IX)
		OP_FUNC(move_l_ea_anix);
		break;
	 case (0x21c0 >> 6):
		// %0010_000111_mmmrrr	MOVE.L <ea>,Abs.W
		OP_FUNC(move_l_ea_absw);
		break;
	 case (0x23c0 >> 6):
		// %0010_001111_mmmrrr	MOVE.L <ea>,Abs.L
		OP_FUNC(move_l_ea_absl);
		break;
	 case (0x3000 >> 6):
	 case (0x3200 >> 6):
	 case (0x3400 >> 6):
	 case (0x3600 >> 6):
	 case (0x3800 >> 6):
	 case (0x3a00 >> 6):
	 case (0x3c00 >> 6):
	 case (0x3e00 >> 6):
		// %0011_xxx000_mmmrrr	MOVE.W <ea>,Dx
		OP_FUNC(move_w_ea_dn);
		break;
	 case (0x3040 >> 6):
	 case (0x3240 >> 6):
	 case (0x3440 >> 6):
	 case (0x3640 >> 6):
	 case (0x3840 >> 6):
	 case (0x3a40 >> 6):
	 case (0x3c40 >> 6):
	 case (0x3e40 >> 6):
		// %0011_xxx001_mmmrrr	MOVEA.W <ea>,Ax
		OP_FUNC(movea_w);
		break;
	 case (0x3080 >> 6):
	 case (0x3280 >> 6):
	 case (0x3480 >> 6):
	 case (0x3680 >> 6):
	 case (0x3880 >> 6):
	 case (0x3a80 >> 6):
	 case (0x3c80 >> 6):
	 case (0x3e80 >> 6):
		// %0011_xxx010_mmmrrr	MOVE.W <ea>,(Ax)
		OP_FUNC(move_w_ea_anin);
		break;
	 case (0x30c0 >> 6):
	 case (0x32c0 >> 6):
	 case (0x34c0 >> 6):
	 case (0x36c0 >> 6):
	 case (0x38c0 >> 6):
	 case (0x3ac0 >> 6):
	 case (0x3cc0 >> 6):
	 case (0x3ec0 >> 6):
		// %0011_xxx011_mmmrrr	MOVE.W <ea>,(Ax)+
		OP_FUNC(move_w_ea_anpi);
		break;
	 case (0x3100 >> 6):
	 case (0x3300 >> 6):
	 case (0x3500 >> 6):
	 case (0x3700 >> 6):
	 case (0x3900 >> 6):
	 case (0x3b00 >> 6):
	 case (0x3d00 >> 6):
	 case (0x3f00 >> 6):
		// %0011_xxx100_mmmrrr	MOVE.W <ea>,-(Ax)
		OP_FUNC(move_w_ea_anpd);
		break;
	 case (0x3140 >> 6):
	 case (0x3340 >> 6):
	 case (0x3540 >> 6):
	 case (0x3740 >> 6):
	 case (0x3940 >> 6):
	 case (0x3b40 >> 6):
	 case (0x3d40 >> 6):
	 case (0x3f40 >> 6):
		// %0011_xxx101_mmmrrr	MOVE.W <ea>,d16(Ax)
		OP_FUNC(move_w_ea_andi);
		break;
	 case (0x3180 >> 6):
	 case (0x3380 >> 6):
	 case (0x3580 >> 6):
	 case (0x3780 >> 6):
	 case (0x3980 >> 6):
	 case (0x3b80 >> 6):
	 case (0x3d80 >> 6):
	 case (0x3f80 >> 6):
		// %0011_xxx110_mmmrrr	MOVE.W <ea>,(Ax,IX)
		OP_FUNC(move_w_ea_anix);
		break;
	 case (0x31c0 >> 6):
		// %0011_000111_mmmrrr	MOVE.W <ea>,Abs.W
		OP_FUNC(move_w_ea_absw);
		break;
	 case (0x33c0 >> 6):
		// %0011_001111_mmmrrr	MOVE.W <ea>,Abs.L
		OP_FUNC(move_w_ea_absl);
		break;
	 case (0x4000 >> 6):
		// %0100_000000_mmmrrr	NEGX.B <ea>
		OP_FUNC(negx_b);
		break;
	 case (0x4040 >> 6):
		// %0100_000001_mmmrrr	NEGX.W <ea>
		OP_FUNC(negx_w);
		break;
	 case (0x4080 >> 6):
		// %0100_000010_mmmrrr	NEGX.L <ea>
		OP_FUNC(negx_l);
		break;
	 case (0x40c0 >> 6):
		// %0100_000011_mmmrrr	MOVE.W SR,<ea>
		OP_FUNC(move_sr_ea);
		break;
	 case (0x4100 >> 6):
	 case (0x4300 >> 6):
	 case (0x4500 >> 6):
	 case (0x4700 >> 6):
	 case (0x4900 >> 6):
	 case (0x4b00 >> 6):
	 case (0x4d00 >> 6):
	 case (0x4f00 >> 6):
		// %0100_xxx100_mmmrrr	CHK.L <ea>,Dx
		OP_FUNC(chk_l);
		break;
	 case (0x4180 >> 6):
	 case (0x4380 >> 6):
	 case (0x4580 >> 6):
	 case (0x4780 >> 6):
	 case (0x4980 >> 6):
	 case (0x4b80 >> 6):
	 case (0x4d80 >> 6):
	 case (0x4f80 >> 6):
		// %0100_xxx110_mmmrrr	CHK.W <ea>,Dx
		OP_FUNC(chk_w);
		break;
	 case (0x41c0 >> 6):
	 case (0x43c0 >> 6):
	 case (0x45c0 >> 6):
	 case (0x47c0 >> 6):
	 case (0x49c0 >> 6):
	 case (0x4bc0 >> 6):
	 case (0x4dc0 >> 6):
	 case (0x4fc0 >> 6):
		// %0100_xxx111_mmmrrr	LEA.L <ea>,Ax
		// %0100_100111_000yyy	EXTB.L Dy
		OP_FUNC(lea);
		break;
	 case (0x4200 >> 6):
		// %0100_001000_mmmrrr	CLR.B <ea>
		OP_FUNC(clr_b);
		break;
	 case (0x4240 >> 6):
		// %0100_001001_mmmrrr	CLR.W <ea>
		OP_FUNC(clr_w);
		break;
	 case (0x4280 >> 6):
		// %0100_001010_mmmrrr	CLR.L <ea>
		OP_FUNC(clr_l);
		break;
	 case (0x42c0 >> 6):
		// %0100_001011_mmmrrr	MOVE.W CCR,<ea>
		OP_FUNC(move_ccr_ea);
		break;
	 case (0x4400 >> 6):
		// %0100_010000_mmmrrr	NEG.B <ea>
		OP_FUNC(neg_b);
		break;
	 case (0x4440 >> 6):
		// %0100_010001_mmmrrr	NEG.W <ea>
		OP_FUNC(neg_w);
		break;
	 case (0x4480 >> 6):
		// %0100_010010_mmmrrr	NEG.L <ea>
		OP_FUNC(neg_l);
		break;
	 case (0x44c0 >> 6):
		// %0100_010011_mmmrrr	MOVE.W <ea>,CCR
		OP_FUNC(move_ea_ccr);
		break;
	 case (0x4600 >> 6):
		// %0100_011000_mmmrrr	NOT.B <ea>
		OP_FUNC(not_b);
		break;
	 case (0x4640 >> 6):
		// %0100_011001_mmmrrr	NOT.W <ea>
		OP_FUNC(not_w);
		break;
	 case (0x4680 >> 6):
		// %0100_011010_mmmrrr	NOT.L <ea>
		OP_FUNC(not_l);
		break;
	 case (0x46c0 >> 6):
		// %0100_011011_mmmrrr	MOVE.W <ea>,SR
		OP_FUNC(move_ea_sr);
		break;
	 case (0x4800 >> 6):
		// %0100_100000_mmmrrr	NBCD.B <ea>
		// %0100_100000_001yyy	LINK.L Ay,#<imm>
		OP_FUNC(nbcd);
		break;
	 case (0x4840 >> 6):
		// %0100_100001_mmmrrr	PEA.L <ea>
		// %0100_100001_000yyy	SWAP.W Dy
		// %0100_100001_001nnn	BKPT #<imm>
		OP_FUNC(pea);
		break;
	 case (0x4880 >> 6):
		// %0100_100010_mmmrrr	MOVEM.W <list>,<ea>
		// %0100_100010_000yyy	EXT.W Dy
		OP_FUNC(movem_w_mem);
		break;
	 case (0x48c0 >> 6):
		// %0100_100011_mmmrrr	MOVEM.L <list>,<ea>
		// %0100_100011_000yyy	EXT.L Dy
		OP_FUNC(movem_l_mem);
		break;
	 case (0x4a00 >> 6):
		// %0100_101000_mmmrrr	TST.B <ea>
		OP_FUNC(tst_b);
		break;
	 case (0x4a40 >> 6):
		// %0100_101001_mmmrrr	TST.W <ea>
		OP_FUNC(tst_w);
		break;
	 case (0x4a80 >> 6):
		// %0100_101010_mmmrrr	TST.L <ea>
		OP_FUNC(tst_l);
		break;
	 case (0x4ac0 >> 6):
		// %0100_101011_mmmrrr	TAS.B <ea>
		// %0100_101011_111100	ILLEGAL
		OP_FUNC(tas);
		break;
	 case (0x4c00 >> 6):
		// %0100_110000_mmmrrr	MULS.L <ea>,Dl
		// %0100_110000_mmmrrr	MULS.L <ea>,Dh:Dl
		// %0100_110000_mmmrrr	MULU.L <ea>,Dl
		// %0100_110000_mmmrrr	MULU.L <ea>,Dh:Dl
		OP_FUNC(mul);
		break;
	 case (0x4c40 >> 6):
		// %0100_110001_mmmrrr	DIVS.L <ea>,Dq
		// %0100_110001_mmmrrr	DIVS.L <ea>,Dr:Dq
		// %0100_110001_mmmrrr	DIVSL.L <ea>,Dr:Dq
		// %0100_110001_mmmrrr	DIVU.L <ea>,Dq
		// %0100_110001_mmmrrr	DIVU.L <ea>,Dr:Dq
		// %0100_110001_mmmrrr	DIVUL.L <ea>,Dr:Dq
		OP_FUNC(div);
		break;
	 case (0x4c80 >> 6):
		// %0100_110010_mmmrrr	MOVEM.W <ea>,<list>
		OP_FUNC(movem_w);
		break;
	 case (0x4cc0 >> 6):
		// %0100_110011_mmmrrr	MOVEM.L <ea>,<list>
		OP_FUNC(movem_l);
		break;
	 case (0x4e40 >> 6):
		// %0100_111001_00nnnn	TRAP #<vector>
		// %0100_111001_010yyy	LINK.W Ay,#<imm>
		// %0100_111001_011yyy	UNLK Ay
		// %0100_111001_100yyy	MOVE.L Ay,USP
		// %0100_111001_101yyy	MOVE.L USP,Ay
		// %0100_111001_110000	RESET
		// %0100_111001_110001	NOP
		// %0100_111001_110010	STOP #<imm>
		// %0100_111001_110011	RTE
		// %0100_111001_110100	RTD #<imm>
		// %0100_111001_110101	RTS
		// %0100_111001_110110	TRAPV
		// %0100_111001_110111	RTR
		// %0100_111001_111010	MOVEC.L Rc,Rn
		// %0100_111001_111011	MOVEC.L Rn,Rc
		OP_FUNC(trap);
		break;
	 case (0x4e80 >> 6):
		// %0100_111010_mmmrrr	JSR <ea>
		OP_FUNC(jsr);
		break;
	 case (0x4ec0 >> 6):
		// %0100_111011_mmmrrr	JMP <ea>
		OP_FUNC(jmp);
		break;
	 case (0x5000 >> 6):
	 case (0x5200 >> 6):
	 case (0x5400 >> 6):
	 case (0x5600 >> 6):
	 case (0x5800 >> 6):
	 case (0x5a00 >> 6):
	 case (0x5c00 >> 6):
	 case (0x5e00 >> 6):
		// %0101_qqq000_mmmrrr	ADDQ.B #qqq,<ea>
		OP_FUNC(addq_b);
		break;
	 case (0x5040 >> 6):
	 case (0x5240 >> 6):
	 case (0x5440 >> 6):
	 case (0x5640 >> 6):
	 case (0x5840 >> 6):
	 case (0x5a40 >> 6):
	 case (0x5c40 >> 6):
	 case (0x5e40 >> 6):
		// %0101_qqq001_mmmrrr	ADDQ.W #qqq,<ea>
		// %0101_qqq001_001yyy	ADDQ.W #qqq,Ay (.Lと等価)
		OP_FUNC(addq_w);
		break;
	 case (0x5080 >> 6):
	 case (0x5280 >> 6):
	 case (0x5480 >> 6):
	 case (0x5680 >> 6):
	 case (0x5880 >> 6):
	 case (0x5a80 >> 6):
	 case (0x5c80 >> 6):
	 case (0x5e80 >> 6):
		// %0101_qqq010_mmmrrr	ADDQ.L #qqq,<ea>
		// %0101_qqq010_001yyy	ADDQ.L #qqq,Ay
		OP_FUNC(addq_l);
		break;
	 case (0x50c0 >> 6):
	 case (0x51c0 >> 6):
	 case (0x52c0 >> 6):
	 case (0x53c0 >> 6):
	 case (0x54c0 >> 6):
	 case (0x55c0 >> 6):
	 case (0x56c0 >> 6):
	 case (0x57c0 >> 6):
	 case (0x58c0 >> 6):
	 case (0x59c0 >> 6):
	 case (0x5ac0 >> 6):
	 case (0x5bc0 >> 6):
	 case (0x5cc0 >> 6):
	 case (0x5dc0 >> 6):
	 case (0x5ec0 >> 6):
	 case (0x5fc0 >> 6):
		// %0101_cccc11_mmmrrr	Scc.B <ea>
		// %0101_cccc11_001yyy	DBcc.W Dy,<label>
		// %0101_cccc11_111010	TRAPcc.W #<imm>
		// %0101_cccc11_111011	TRAPcc.L #<imm>
		// %0101_cccc11_111100	TRAPcc
		// %0101_000111_001yyy	DBRA.W Dy,<label>
		OP_FUNC(scc);
		break;
	 case (0x5100 >> 6):
	 case (0x5300 >> 6):
	 case (0x5500 >> 6):
	 case (0x5700 >> 6):
	 case (0x5900 >> 6):
	 case (0x5b00 >> 6):
	 case (0x5d00 >> 6):
	 case (0x5f00 >> 6):
		// %0101_qqq100_mmmrrr	SUBQ.B #qqq,<ea>
		OP_FUNC(subq_b);
		break;
	 case (0x5140 >> 6):
	 case (0x5340 >> 6):
	 case (0x5540 >> 6):
	 case (0x5740 >> 6):
	 case (0x5940 >> 6):
	 case (0x5b40 >> 6):
	 case (0x5d40 >> 6):
	 case (0x5f40 >> 6):
		// %0101_qqq101_mmmrrr	SUBQ.W #qqq,<ea>
		// %0101_qqq101_001yyy	SUBQ.W #qqq,Ay (.Lと等価)
		OP_FUNC(subq_w);
		break;
	 case (0x5180 >> 6):
	 case (0x5380 >> 6):
	 case (0x5580 >> 6):
	 case (0x5780 >> 6):
	 case (0x5980 >> 6):
	 case (0x5b80 >> 6):
	 case (0x5d80 >> 6):
	 case (0x5f80 >> 6):
		// %0101_qqq110_mmmrrr	SUBQ.L #qqq,<ea>
		// %0101_qqq110_001yyy	SUBQ.L #qqq,Ay
		OP_FUNC(subq_l);
		break;
	 case (0x6000 >> 6):
	 case (0x6040 >> 6):
	 case (0x6080 >> 6):
	 case (0x60c0 >> 6):
		// %0110_0000nn_nnnnnn	BRA.B <label>
		// %0110_000000_000000	BRA.W <label>
		// %0110_000011_111111	BRA.L <label>
		OP_FUNC(bra);
		break;
	 case (0x6100 >> 6):
	 case (0x6140 >> 6):
	 case (0x6180 >> 6):
	 case (0x61c0 >> 6):
		// %0110_0001nn_nnnnnn	BSR.B <label>
		// %0110_000100_000000	BSR.W <label>
		// %0110_000111_111111	BSR.L <label>
		OP_FUNC(bsr);
		break;
	 case (0x6200 >> 6):
	 case (0x6240 >> 6):
	 case (0x6280 >> 6):
	 case (0x62c0 >> 6):
	 case (0x6300 >> 6):
	 case (0x6340 >> 6):
	 case (0x6380 >> 6):
	 case (0x63c0 >> 6):
	 case (0x6400 >> 6):
	 case (0x6440 >> 6):
	 case (0x6480 >> 6):
	 case (0x64c0 >> 6):
	 case (0x6500 >> 6):
	 case (0x6540 >> 6):
	 case (0x6580 >> 6):
	 case (0x65c0 >> 6):
	 case (0x6600 >> 6):
	 case (0x6640 >> 6):
	 case (0x6680 >> 6):
	 case (0x66c0 >> 6):
	 case (0x6700 >> 6):
	 case (0x6740 >> 6):
	 case (0x6780 >> 6):
	 case (0x67c0 >> 6):
	 case (0x6800 >> 6):
	 case (0x6840 >> 6):
	 case (0x6880 >> 6):
	 case (0x68c0 >> 6):
	 case (0x6900 >> 6):
	 case (0x6940 >> 6):
	 case (0x6980 >> 6):
	 case (0x69c0 >> 6):
	 case (0x6a00 >> 6):
	 case (0x6a40 >> 6):
	 case (0x6a80 >> 6):
	 case (0x6ac0 >> 6):
	 case (0x6b00 >> 6):
	 case (0x6b40 >> 6):
	 case (0x6b80 >> 6):
	 case (0x6bc0 >> 6):
	 case (0x6c00 >> 6):
	 case (0x6c40 >> 6):
	 case (0x6c80 >> 6):
	 case (0x6cc0 >> 6):
	 case (0x6d00 >> 6):
	 case (0x6d40 >> 6):
	 case (0x6d80 >> 6):
	 case (0x6dc0 >> 6):
	 case (0x6e00 >> 6):
	 case (0x6e40 >> 6):
	 case (0x6e80 >> 6):
	 case (0x6ec0 >> 6):
	 case (0x6f00 >> 6):
	 case (0x6f40 >> 6):
	 case (0x6f80 >> 6):
	 case (0x6fc0 >> 6):
		// %0110_ccccnn_nnnnnn	Bcc.B <label>
		// %0110_cccc00_000000	Bcc.W <label>
		// %0110_cccc11_111111	Bcc.L <label>
		OP_FUNC(bcc);
		break;
	 case (0x7000 >> 6):
	 case (0x7040 >> 6):
	 case (0x7080 >> 6):
	 case (0x70c0 >> 6):
	 case (0x7200 >> 6):
	 case (0x7240 >> 6):
	 case (0x7280 >> 6):
	 case (0x72c0 >> 6):
	 case (0x7400 >> 6):
	 case (0x7440 >> 6):
	 case (0x7480 >> 6):
	 case (0x74c0 >> 6):
	 case (0x7600 >> 6):
	 case (0x7640 >> 6):
	 case (0x7680 >> 6):
	 case (0x76c0 >> 6):
	 case (0x7800 >> 6):
	 case (0x7840 >> 6):
	 case (0x7880 >> 6):
	 case (0x78c0 >> 6):
	 case (0x7a00 >> 6):
	 case (0x7a40 >> 6):
	 case (0x7a80 >> 6):
	 case (0x7ac0 >> 6):
	 case (0x7c00 >> 6):
	 case (0x7c40 >> 6):
	 case (0x7c80 >> 6):
	 case (0x7cc0 >> 6):
	 case (0x7e00 >> 6):
	 case (0x7e40 >> 6):
	 case (0x7e80 >> 6):
	 case (0x7ec0 >> 6):
		// %0111_xxx0nn_nnnnnn	MOVEQ.L #<imm>,Dx
		OP_FUNC(moveq);
		break;
	 case (0x8000 >> 6):
	 case (0x8200 >> 6):
	 case (0x8400 >> 6):
	 case (0x8600 >> 6):
	 case (0x8800 >> 6):
	 case (0x8a00 >> 6):
	 case (0x8c00 >> 6):
	 case (0x8e00 >> 6):
		// %1000_xxx000_mmmrrr	OR.B <ea>,Dx
		OP_FUNC(or_b_ea_dn);
		break;
	 case (0x8040 >> 6):
	 case (0x8240 >> 6):
	 case (0x8440 >> 6):
	 case (0x8640 >> 6):
	 case (0x8840 >> 6):
	 case (0x8a40 >> 6):
	 case (0x8c40 >> 6):
	 case (0x8e40 >> 6):
		// %1000_xxx001_mmmrrr	OR.W <ea>,Dx
		OP_FUNC(or_w_ea_dn);
		break;
	 case (0x8080 >> 6):
	 case (0x8280 >> 6):
	 case (0x8480 >> 6):
	 case (0x8680 >> 6):
	 case (0x8880 >> 6):
	 case (0x8a80 >> 6):
	 case (0x8c80 >> 6):
	 case (0x8e80 >> 6):
		// %1000_xxx010_mmmrrr	OR.L <ea>,Dx
		OP_FUNC(or_l_ea_dn);
		break;
	 case (0x80c0 >> 6):
	 case (0x82c0 >> 6):
	 case (0x84c0 >> 6):
	 case (0x86c0 >> 6):
	 case (0x88c0 >> 6):
	 case (0x8ac0 >> 6):
	 case (0x8cc0 >> 6):
	 case (0x8ec0 >> 6):
		// %1000_xxx011_mmmrrr	DIVU.W <ea>,Dx
		OP_FUNC(divu_w);
		break;
	 case (0x8100 >> 6):
	 case (0x8300 >> 6):
	 case (0x8500 >> 6):
	 case (0x8700 >> 6):
	 case (0x8900 >> 6):
	 case (0x8b00 >> 6):
	 case (0x8d00 >> 6):
	 case (0x8f00 >> 6):
		// %1000_xxx100_mmmrrr	OR.B Dx,<ea>
		// %1000_xxx100_000yyy	SBCD.B Dy,Dx
		// %1000_xxx100_001yyy	SBCD.B -(Ay),-(Ax)
		OP_FUNC(or_b_dn_ea);
		break;
	 case (0x8140 >> 6):
	 case (0x8340 >> 6):
	 case (0x8540 >> 6):
	 case (0x8740 >> 6):
	 case (0x8940 >> 6):
	 case (0x8b40 >> 6):
	 case (0x8d40 >> 6):
	 case (0x8f40 >> 6):
		// %1000_xxx101_mmmrrr	OR.W Dx,<ea>
		// %1000_xxx101_000yyy	PACK Dy,Dx,#<imm>
		// %1000_xxx101_001yyy	PACK -(Ay),-(Ax),#<imm>
		OP_FUNC(or_w_dn_ea);
		break;
	 case (0x8180 >> 6):
	 case (0x8380 >> 6):
	 case (0x8580 >> 6):
	 case (0x8780 >> 6):
	 case (0x8980 >> 6):
	 case (0x8b80 >> 6):
	 case (0x8d80 >> 6):
	 case (0x8f80 >> 6):
		// %1000_xxx110_mmmrrr	OR.L Dx,<ea>
		// %1000_xxx110_000yyy	UNPK Dy,Dx,#<imm>
		// %1000_xxx110_001yyy	UNPK -(Ay),-(Ax),#<imm>
		OP_FUNC(or_l_dn_ea);
		break;
	 case (0x81c0 >> 6):
	 case (0x83c0 >> 6):
	 case (0x85c0 >> 6):
	 case (0x87c0 >> 6):
	 case (0x89c0 >> 6):
	 case (0x8bc0 >> 6):
	 case (0x8dc0 >> 6):
	 case (0x8fc0 >> 6):
		// %1000_xxx111_mmmrrr	DIVS.W <ea>,Dx
		OP_FUNC(divs_w);
		break;
	 case (0x9000 >> 6):
	 case (0x9200 >> 6):
	 case (0x9400 >> 6):
	 case (0x9600 >> 6):
	 case (0x9800 >> 6):
	 case (0x9a00 >> 6):
	 case (0x9c00 >> 6):
	 case (0x9e00 >> 6):
		// %1001_xxx000_mmmrrr	SUB.B <ea>,Dx
		OP_FUNC(sub_b_ea_dn);
		break;
	 case (0x9040 >> 6):
	 case (0x9240 >> 6):
	 case (0x9440 >> 6):
	 case (0x9640 >> 6):
	 case (0x9840 >> 6):
	 case (0x9a40 >> 6):
	 case (0x9c40 >> 6):
	 case (0x9e40 >> 6):
		// %1001_xxx001_mmmrrr	SUB.W <ea>,Dx
		OP_FUNC(sub_w_ea_dn);
		break;
	 case (0x9080 >> 6):
	 case (0x9280 >> 6):
	 case (0x9480 >> 6):
	 case (0x9680 >> 6):
	 case (0x9880 >> 6):
	 case (0x9a80 >> 6):
	 case (0x9c80 >> 6):
	 case (0x9e80 >> 6):
		// %1001_xxx010_mmmrrr	SUB.L <ea>,Dx
		OP_FUNC(sub_l_ea_dn);
		break;
	 case (0x90c0 >> 6):
	 case (0x92c0 >> 6):
	 case (0x94c0 >> 6):
	 case (0x96c0 >> 6):
	 case (0x98c0 >> 6):
	 case (0x9ac0 >> 6):
	 case (0x9cc0 >> 6):
	 case (0x9ec0 >> 6):
		// %1001_xxx011_mmmrrr	SUBA.W <ea>,Ax
		OP_FUNC(suba_w);
		break;
	 case (0x9100 >> 6):
	 case (0x9300 >> 6):
	 case (0x9500 >> 6):
	 case (0x9700 >> 6):
	 case (0x9900 >> 6):
	 case (0x9b00 >> 6):
	 case (0x9d00 >> 6):
	 case (0x9f00 >> 6):
		// %1001_xxx100_mmmrrr	SUB.B Dx,<ea>
		// %1001_xxx100_000yyy	SUBX.B Dy,Dx
		// %1001_xxx100_001yyy	SUBX.B -(Ay),-(Ax)
		OP_FUNC(sub_b_dn_ea);
		break;
	 case (0x9140 >> 6):
	 case (0x9340 >> 6):
	 case (0x9540 >> 6):
	 case (0x9740 >> 6):
	 case (0x9940 >> 6):
	 case (0x9b40 >> 6):
	 case (0x9d40 >> 6):
	 case (0x9f40 >> 6):
		// %1001_xxx101_mmmrrr	SUB.W Dx,<ea>
		// %1001_xxx101_000yyy	SUBX.W Dy,Dx
		// %1001_xxx101_001yyy	SUBX.W -(Ay),-(Ax)
		OP_FUNC(sub_w_dn_ea);
		break;
	 case (0x9180 >> 6):
	 case (0x9380 >> 6):
	 case (0x9580 >> 6):
	 case (0x9780 >> 6):
	 case (0x9980 >> 6):
	 case (0x9b80 >> 6):
	 case (0x9d80 >> 6):
	 case (0x9f80 >> 6):
		// %1001_xxx110_mmmrrr	SUB.L Dx,<ea>
		// %1001_xxx110_000yyy	SUBX.L Dy,Dx
		// %1001_xxx110_001yyy	SUBX.L -(Ay),-(Ax)
		OP_FUNC(sub_l_dn_ea);
		break;
	 case (0x91c0 >> 6):
	 case (0x93c0 >> 6):
	 case (0x95c0 >> 6):
	 case (0x97c0 >> 6):
	 case (0x99c0 >> 6):
	 case (0x9bc0 >> 6):
	 case (0x9dc0 >> 6):
	 case (0x9fc0 >> 6):
		// %1001_xxx111_mmmrrr	SUBA.L <ea>,Ax
		OP_FUNC(suba_l);
		break;
	 case (0xa000 >> 6):
	 case (0xa040 >> 6):
	 case (0xa080 >> 6):
	 case (0xa0c0 >> 6):
	 case (0xa100 >> 6):
	 case (0xa140 >> 6):
	 case (0xa180 >> 6):
	 case (0xa1c0 >> 6):
	 case (0xa200 >> 6):
	 case (0xa240 >> 6):
	 case (0xa280 >> 6):
	 case (0xa2c0 >> 6):
	 case (0xa300 >> 6):
	 case (0xa340 >> 6):
	 case (0xa380 >> 6):
	 case (0xa3c0 >> 6):
	 case (0xa400 >> 6):
	 case (0xa440 >> 6):
	 case (0xa480 >> 6):
	 case (0xa4c0 >> 6):
	 case (0xa500 >> 6):
	 case (0xa540 >> 6):
	 case (0xa580 >> 6):
	 case (0xa5c0 >> 6):
	 case (0xa600 >> 6):
	 case (0xa640 >> 6):
	 case (0xa680 >> 6):
	 case (0xa6c0 >> 6):
	 case (0xa700 >> 6):
	 case (0xa740 >> 6):
	 case (0xa780 >> 6):
	 case (0xa7c0 >> 6):
	 case (0xa800 >> 6):
	 case (0xa840 >> 6):
	 case (0xa880 >> 6):
	 case (0xa8c0 >> 6):
	 case (0xa900 >> 6):
	 case (0xa940 >> 6):
	 case (0xa980 >> 6):
	 case (0xa9c0 >> 6):
	 case (0xaa00 >> 6):
	 case (0xaa40 >> 6):
	 case (0xaa80 >> 6):
	 case (0xaac0 >> 6):
	 case (0xab00 >> 6):
	 case (0xab40 >> 6):
	 case (0xab80 >> 6):
	 case (0xabc0 >> 6):
	 case (0xac00 >> 6):
	 case (0xac40 >> 6):
	 case (0xac80 >> 6):
	 case (0xacc0 >> 6):
	 case (0xad00 >> 6):
	 case (0xad40 >> 6):
	 case (0xad80 >> 6):
	 case (0xadc0 >> 6):
	 case (0xae00 >> 6):
	 case (0xae40 >> 6):
	 case (0xae80 >> 6):
	 case (0xaec0 >> 6):
	 case (0xaf00 >> 6):
	 case (0xaf40 >> 6):
	 case (0xaf80 >> 6):
	 case (0xafc0 >> 6):
		// %1010_nnnnnn_nnnnnn	A-Line
		OP_FUNC(aline);
		break;
	 case (0xb000 >> 6):
	 case (0xb200 >> 6):
	 case (0xb400 >> 6):
	 case (0xb600 >> 6):
	 case (0xb800 >> 6):
	 case (0xba00 >> 6):
	 case (0xbc00 >> 6):
	 case (0xbe00 >> 6):
		// %1011_xxx000_mmmrrr	CMP.B <ea>,Dx
		OP_FUNC(cmp_b);
		break;
	 case (0xb040 >> 6):
	 case (0xb240 >> 6):
	 case (0xb440 >> 6):
	 case (0xb640 >> 6):
	 case (0xb840 >> 6):
	 case (0xba40 >> 6):
	 case (0xbc40 >> 6):
	 case (0xbe40 >> 6):
		// %1011_xxx001_mmmrrr	CMP.W <ea>,Dx
		OP_FUNC(cmp_w);
		break;
	 case (0xb080 >> 6):
	 case (0xb280 >> 6):
	 case (0xb480 >> 6):
	 case (0xb680 >> 6):
	 case (0xb880 >> 6):
	 case (0xba80 >> 6):
	 case (0xbc80 >> 6):
	 case (0xbe80 >> 6):
		// %1011_xxx010_mmmrrr	CMP.L <ea>,Dx
		OP_FUNC(cmp_l);
		break;
	 case (0xb0c0 >> 6):
	 case (0xb2c0 >> 6):
	 case (0xb4c0 >> 6):
	 case (0xb6c0 >> 6):
	 case (0xb8c0 >> 6):
	 case (0xbac0 >> 6):
	 case (0xbcc0 >> 6):
	 case (0xbec0 >> 6):
		// %1011_xxx011_mmmrrr	CMPA.W <ea>,Ax
		OP_FUNC(cmpa_w);
		break;
	 case (0xb100 >> 6):
	 case (0xb300 >> 6):
	 case (0xb500 >> 6):
	 case (0xb700 >> 6):
	 case (0xb900 >> 6):
	 case (0xbb00 >> 6):
	 case (0xbd00 >> 6):
	 case (0xbf00 >> 6):
		// %1011_xxx100_mmmrrr	EOR.B Dx,<ea>
		// %1011_xxx100_001yyy	CMPM.B (Ay)+,(Ax)+
		OP_FUNC(eor_b);
		break;
	 case (0xb140 >> 6):
	 case (0xb340 >> 6):
	 case (0xb540 >> 6):
	 case (0xb740 >> 6):
	 case (0xb940 >> 6):
	 case (0xbb40 >> 6):
	 case (0xbd40 >> 6):
	 case (0xbf40 >> 6):
		// %1011_xxx101_mmmrrr	EOR.W Dx,<ea>
		// %1011_xxx101_001yyy	CMPM.W (Ay)+,(Ax)+
		OP_FUNC(eor_w);
		break;
	 case (0xb180 >> 6):
	 case (0xb380 >> 6):
	 case (0xb580 >> 6):
	 case (0xb780 >> 6):
	 case (0xb980 >> 6):
	 case (0xbb80 >> 6):
	 case (0xbd80 >> 6):
	 case (0xbf80 >> 6):
		// %1011_xxx110_mmmrrr	EOR.L Dx,<ea>
		// %1011_xxx110_001yyy	CMPM.L (Ay)+,(Ax)+
		OP_FUNC(eor_l);
		break;
	 case (0xb1c0 >> 6):
	 case (0xb3c0 >> 6):
	 case (0xb5c0 >> 6):
	 case (0xb7c0 >> 6):
	 case (0xb9c0 >> 6):
	 case (0xbbc0 >> 6):
	 case (0xbdc0 >> 6):
	 case (0xbfc0 >> 6):
		// %1011_xxx111_mmmrrr	CMPA.L <ea>,Ax
		OP_FUNC(cmpa_l);
		break;
	 case (0xc000 >> 6):
	 case (0xc200 >> 6):
	 case (0xc400 >> 6):
	 case (0xc600 >> 6):
	 case (0xc800 >> 6):
	 case (0xca00 >> 6):
	 case (0xcc00 >> 6):
	 case (0xce00 >> 6):
		// %1100_xxx000_mmmrrr	AND.B <ea>,Dx
		OP_FUNC(and_b_ea_dn);
		break;
	 case (0xc040 >> 6):
	 case (0xc240 >> 6):
	 case (0xc440 >> 6):
	 case (0xc640 >> 6):
	 case (0xc840 >> 6):
	 case (0xca40 >> 6):
	 case (0xcc40 >> 6):
	 case (0xce40 >> 6):
		// %1100_xxx001_mmmrrr	AND.W <ea>,Dx
		OP_FUNC(and_w_ea_dn);
		break;
	 case (0xc080 >> 6):
	 case (0xc280 >> 6):
	 case (0xc480 >> 6):
	 case (0xc680 >> 6):
	 case (0xc880 >> 6):
	 case (0xca80 >> 6):
	 case (0xcc80 >> 6):
	 case (0xce80 >> 6):
		// %1100_xxx010_mmmrrr	AND.L <ea>,Dx
		OP_FUNC(and_l_ea_dn);
		break;
	 case (0xc0c0 >> 6):
	 case (0xc2c0 >> 6):
	 case (0xc4c0 >> 6):
	 case (0xc6c0 >> 6):
	 case (0xc8c0 >> 6):
	 case (0xcac0 >> 6):
	 case (0xccc0 >> 6):
	 case (0xcec0 >> 6):
		// %1100_xxx011_mmmrrr	MULU.W <ea>,Dx
		OP_FUNC(mulu_w);
		break;
	 case (0xc100 >> 6):
	 case (0xc300 >> 6):
	 case (0xc500 >> 6):
	 case (0xc700 >> 6):
	 case (0xc900 >> 6):
	 case (0xcb00 >> 6):
	 case (0xcd00 >> 6):
	 case (0xcf00 >> 6):
		// %1100_xxx100_mmmrrr	AND.B Dx,<ea>
		// %1100_xxx100_000yyy	ABCD.B Dy,Dx
		// %1100_xxx100_001yyy	ABCD.B -(Ay),-(Ax)
		OP_FUNC(and_b_dn_ea);
		break;
	 case (0xc140 >> 6):
	 case (0xc340 >> 6):
	 case (0xc540 >> 6):
	 case (0xc740 >> 6):
	 case (0xc940 >> 6):
	 case (0xcb40 >> 6):
	 case (0xcd40 >> 6):
	 case (0xcf40 >> 6):
		// %1100_xxx101_mmmrrr	AND.W Dx,<ea>
		// %1100_xxx101_000yyy	EXG.L Dx,Dy
		// %1100_xxx101_001yyy	EXG.L Ax,Ay
		OP_FUNC(and_w_dn_ea);
		break;
	 case (0xc180 >> 6):
	 case (0xc380 >> 6):
	 case (0xc580 >> 6):
	 case (0xc780 >> 6):
	 case (0xc980 >> 6):
	 case (0xcb80 >> 6):
	 case (0xcd80 >> 6):
	 case (0xcf80 >> 6):
		// %1100_xxx110_mmmrrr	AND.L Dx,<ea>
		// %1100_xxx110_001yyy	EXG.L Dx,Ay
		OP_FUNC(and_l_dn_ea);
		break;
	 case (0xc1c0 >> 6):
	 case (0xc3c0 >> 6):
	 case (0xc5c0 >> 6):
	 case (0xc7c0 >> 6):
	 case (0xc9c0 >> 6):
	 case (0xcbc0 >> 6):
	 case (0xcdc0 >> 6):
	 case (0xcfc0 >> 6):
		// %1100_xxx111_mmmrrr	MULS.W <ea>,Dx
		OP_FUNC(muls_w);
		break;
	 case (0xd000 >> 6):
	 case (0xd200 >> 6):
	 case (0xd400 >> 6):
	 case (0xd600 >> 6):
	 case (0xd800 >> 6):
	 case (0xda00 >> 6):
	 case (0xdc00 >> 6):
	 case (0xde00 >> 6):
		// %1101_xxx000_mmmrrr	ADD.B <ea>,Dx
		OP_FUNC(add_b_ea_dn);
		break;
	 case (0xd040 >> 6):
	 case (0xd240 >> 6):
	 case (0xd440 >> 6):
	 case (0xd640 >> 6):
	 case (0xd840 >> 6):
	 case (0xda40 >> 6):
	 case (0xdc40 >> 6):
	 case (0xde40 >> 6):
		// %1101_xxx001_mmmrrr	ADD.W <ea>,Dx
		OP_FUNC(add_w_ea_dn);
		break;
	 case (0xd080 >> 6):
	 case (0xd280 >> 6):
	 case (0xd480 >> 6):
	 case (0xd680 >> 6):
	 case (0xd880 >> 6):
	 case (0xda80 >> 6):
	 case (0xdc80 >> 6):
	 case (0xde80 >> 6):
		// %1101_xxx010_mmmrrr	ADD.L <ea>,Dx
		OP_FUNC(add_l_ea_dn);
		break;
	 case (0xd0c0 >> 6):
	 case (0xd2c0 >> 6):
	 case (0xd4c0 >> 6):
	 case (0xd6c0 >> 6):
	 case (0xd8c0 >> 6):
	 case (0xdac0 >> 6):
	 case (0xdcc0 >> 6):
	 case (0xdec0 >> 6):
		// %1101_xxx011_mmmrrr	ADDA.W <ea>,Ax
		OP_FUNC(adda_w);
		break;
	 case (0xd100 >> 6):
	 case (0xd300 >> 6):
	 case (0xd500 >> 6):
	 case (0xd700 >> 6):
	 case (0xd900 >> 6):
	 case (0xdb00 >> 6):
	 case (0xdd00 >> 6):
	 case (0xdf00 >> 6):
		// %1101_xxx100_mmmrrr	ADD.B Dx,<ea>
		// %1101_xxx100_000yyy	ADDX.B Dy,Dx
		// %1101_xxx100_001yyy	ADDX.B -(Ay),-(Ax)
		OP_FUNC(add_b_dn_ea);
		break;
	 case (0xd140 >> 6):
	 case (0xd340 >> 6):
	 case (0xd540 >> 6):
	 case (0xd740 >> 6):
	 case (0xd940 >> 6):
	 case (0xdb40 >> 6):
	 case (0xdd40 >> 6):
	 case (0xdf40 >> 6):
		// %1101_xxx101_mmmrrr	ADD.W Dx,<ea>
		// %1101_xxx101_000yyy	ADDX.W Dy,Dx
		// %1101_xxx101_001yyy	ADDX.W -(Ay),-(Ax)
		OP_FUNC(add_w_dn_ea);
		break;
	 case (0xd180 >> 6):
	 case (0xd380 >> 6):
	 case (0xd580 >> 6):
	 case (0xd780 >> 6):
	 case (0xd980 >> 6):
	 case (0xdb80 >> 6):
	 case (0xdd80 >> 6):
	 case (0xdf80 >> 6):
		// %1101_xxx110_mmmrrr	ADD.L Dx,<ea>
		// %1101_xxx110_000yyy	ADDX.L Dy,Dx
		// %1101_xxx110_001yyy	ADDX.L -(Ay),-(Ax)
		OP_FUNC(add_l_dn_ea);
		break;
	 case (0xd1c0 >> 6):
	 case (0xd3c0 >> 6):
	 case (0xd5c0 >> 6):
	 case (0xd7c0 >> 6):
	 case (0xd9c0 >> 6):
	 case (0xdbc0 >> 6):
	 case (0xddc0 >> 6):
	 case (0xdfc0 >> 6):
		// %1101_xxx111_mmmrrr	ADDA.L <ea>,Ax
		OP_FUNC(adda_l);
		break;
	 case (0xe000 >> 6):
	 case (0xe200 >> 6):
	 case (0xe400 >> 6):
	 case (0xe600 >> 6):
	 case (0xe800 >> 6):
	 case (0xea00 >> 6):
	 case (0xec00 >> 6):
	 case (0xee00 >> 6):
		// %1110_qqq000_000yyy	ASR.B #qqq,Dy
		// %1110_qqq000_001yyy	LSR.B #qqq,Dy
		// %1110_qqq000_010yyy	ROXR.B #qqq,Dy
		// %1110_qqq000_011yyy	ROR.B #qqq,Dy
		// %1110_xxx000_100yyy	ASR.B Dx,Dy
		// %1110_xxx000_101yyy	LSR.B Dx,Dy
		// %1110_xxx000_110yyy	ROXR.B Dx,Dy
		// %1110_xxx000_111yyy	ROR.B Dx,Dy
		OP_FUNC(asr_b_imm);
		break;
	 case (0xe040 >> 6):
	 case (0xe240 >> 6):
	 case (0xe440 >> 6):
	 case (0xe640 >> 6):
	 case (0xe840 >> 6):
	 case (0xea40 >> 6):
	 case (0xec40 >> 6):
	 case (0xee40 >> 6):
		// %1110_qqq001_000yyy	ASR.W #qqq,Dy
		// %1110_qqq001_001yyy	LSR.W #qqq,Dy
		// %1110_qqq001_010yyy	ROXR.W #qqq,Dy
		// %1110_qqq001_011yyy	ROR.W #qqq,Dy
		// %1110_xxx001_100yyy	ASR.W Dx,Dy
		// %1110_xxx001_101yyy	LSR.W Dx,Dy
		// %1110_xxx001_110yyy	ROXR.W Dx,Dy
		// %1110_xxx001_111yyy	ROR.W Dx,Dy
		OP_FUNC(asr_w_imm);
		break;
	 case (0xe080 >> 6):
	 case (0xe280 >> 6):
	 case (0xe480 >> 6):
	 case (0xe680 >> 6):
	 case (0xe880 >> 6):
	 case (0xea80 >> 6):
	 case (0xec80 >> 6):
	 case (0xee80 >> 6):
		// %1110_qqq010_000yyy	ASR.L #qqq,Dy
		// %1110_qqq010_001yyy	LSR.L #qqq,Dy
		// %1110_qqq010_010yyy	ROXR.L #qqq,Dy
		// %1110_qqq010_011yyy	ROR.L #qqq,Dy
		// %1110_xxx010_100yyy	ASR.L Dx,Dy
		// %1110_xxx010_101yyy	LSR.L Dx,Dy
		// %1110_xxx010_110yyy	ROXR.L Dx,Dy
		// %1110_xxx010_111yyy	ROR.L Dx,Dy
		OP_FUNC(asr_l_imm);
		break;
	 case (0xe0c0 >> 6):
		// %1110_000011_mmmrrr	ASR.W <ea>
		OP_FUNC(asr_w);
		break;
	 case (0xe100 >> 6):
	 case (0xe300 >> 6):
	 case (0xe500 >> 6):
	 case (0xe700 >> 6):
	 case (0xe900 >> 6):
	 case (0xeb00 >> 6):
	 case (0xed00 >> 6):
	 case (0xef00 >> 6):
		// %1110_qqq100_000yyy	ASL.B #qqq,Dy
		// %1110_qqq100_001yyy	LSL.B #qqq,Dy
		// %1110_qqq100_010yyy	ROXL.B #qqq,Dy
		// %1110_qqq100_011yyy	ROL.B #qqq,Dy
		// %1110_xxx100_100yyy	ASL.B Dx,Dy
		// %1110_xxx100_101yyy	LSL.B Dx,Dy
		// %1110_xxx100_110yyy	ROXL.B Dx,Dy
		// %1110_xxx100_111yyy	ROL.B Dx,Dy
		OP_FUNC(asl_b_imm);
		break;
	 case (0xe140 >> 6):
	 case (0xe340 >> 6):
	 case (0xe540 >> 6):
	 case (0xe740 >> 6):
	 case (0xe940 >> 6):
	 case (0xeb40 >> 6):
	 case (0xed40 >> 6):
	 case (0xef40 >> 6):
		// %1110_qqq101_000yyy	ASL.W #qqq,Dy
		// %1110_qqq101_001yyy	LSL.W #qqq,Dy
		// %1110_qqq101_010yyy	ROXL.W #qqq,Dy
		// %1110_qqq101_011yyy	ROL.W #qqq,Dy
		// %1110_xxx101_100yyy	ASL.W Dx,Dy
		// %1110_xxx101_101yyy	LSL.W Dx,Dy
		// %1110_xxx101_110yyy	ROXL.W Dx,Dy
		// %1110_xxx101_111yyy	ROL.W Dx,Dy
		OP_FUNC(asl_w_imm);
		break;
	 case (0xe180 >> 6):
	 case (0xe380 >> 6):
	 case (0xe580 >> 6):
	 case (0xe780 >> 6):
	 case (0xe980 >> 6):
	 case (0xeb80 >> 6):
	 case (0xed80 >> 6):
	 case (0xef80 >> 6):
		// %1110_qqq110_000yyy	ASL.L #qqq,Dy
		// %1110_qqq110_001yyy	LSL.L #qqq,Dy
		// %1110_qqq110_010yyy	ROXL.L #qqq,Dy
		// %1110_qqq110_011yyy	ROL.L #qqq,Dy
		// %1110_xxx110_100yyy	ASL.L Dx,Dy
		// %1110_xxx110_101yyy	LSL.L Dx,Dy
		// %1110_xxx110_110yyy	ROXL.L Dx,Dy
		// %1110_xxx110_111yyy	ROL.L Dx,Dy
		OP_FUNC(asl_l_imm);
		break;
	 case (0xe1c0 >> 6):
		// %1110_000111_mmmrrr	ASL.W <ea>
		OP_FUNC(asl_w);
		break;
	 case (0xe2c0 >> 6):
		// %1110_001011_mmmrrr	LSR.W <ea>
		OP_FUNC(lsr_w);
		break;
	 case (0xe3c0 >> 6):
		// %1110_001111_mmmrrr	LSL.W <ea>
		OP_FUNC(lsl_w);
		break;
	 case (0xe4c0 >> 6):
		// %1110_010011_mmmrrr	ROXR.W <ea>
		OP_FUNC(roxr_w);
		break;
	 case (0xe5c0 >> 6):
		// %1110_010111_mmmrrr	ROXL.W <ea>
		OP_FUNC(roxl_w);
		break;
	 case (0xe6c0 >> 6):
		// %1110_011011_mmmrrr	ROR.W <ea>
		OP_FUNC(ror_w);
		break;
	 case (0xe7c0 >> 6):
		// %1110_011111_mmmrrr	ROL.W <ea>
		OP_FUNC(rol_w);
		break;
	 case (0xe8c0 >> 6):
		// %1110_100011_mmmrrr	BFTST <ea>{#o:#w}
		OP_FUNC(bftst);
		break;
	 case (0xe9c0 >> 6):
		// %1110_100111_mmmrrr	BFEXTU <ea>{#o:#w},Dn
		OP_FUNC(bfextu);
		break;
	 case (0xeac0 >> 6):
		// %1110_101011_mmmrrr	BFCHG <ea>{#o:#w}
		OP_FUNC(bfchg);
		break;
	 case (0xebc0 >> 6):
		// %1110_101111_mmmrrr	BFEXTS <ea>{#o:#w},Dn
		OP_FUNC(bfexts);
		break;
	 case (0xecc0 >> 6):
		// %1110_110011_mmmrrr	BFCLR <ea>{#o:#w}
		OP_FUNC(bfclr);
		break;
	 case (0xedc0 >> 6):
		// %1110_110111_mmmrrr	BFFFO <ea>{#o:#w},Dn
		OP_FUNC(bfffo);
		break;
	 case (0xeec0 >> 6):
		// %1110_111011_mmmrrr	BFSET <ea>{#o:#w}
		OP_FUNC(bfset);
		break;
	 case (0xefc0 >> 6):
		// %1110_111111_mmmrrr	BFINS Dn,<ea>{#o:#w}
		OP_FUNC(bfins);
		break;
	 case (0xf000 >> 6):
	 case (0xf040 >> 6):
	 case (0xf080 >> 6):
	 case (0xf0c0 >> 6):
	 case (0xf100 >> 6):
	 case (0xf140 >> 6):
	 case (0xf180 >> 6):
	 case (0xf1c0 >> 6):
		// %1111_000nnn_nnnnnn	MMU30_OP
		OP_FUNC(mmu30);
		break;
	 case (0xf200 >> 6):
		// %1111_001000_nnnnnn	FPGEN
		OP_FUNC(fpgen);
		break;
	 case (0xf240 >> 6):
		// %1111_001001_mmmrrr	FScc.B <ea>
		// %1111_001001_001yyy	FDBcc Dy,<label>
		// %1111_001001_111010	FTRAPcc.W #<imm>
		// %1111_001001_111011	FTRAPcc.L #<imm>
		// %1111_001001_111100	FTRAPcc
		OP_FUNC(fxcc);
		break;
	 case (0xf280 >> 6):
		// %1111_001010_nnnnnn	FBcc.W <label>
		OP_FUNC(fbcc_w);
		break;
	 case (0xf2c0 >> 6):
		// %1111_001011_nnnnnn	FBcc.L <label>
		OP_FUNC(fbcc_l);
		break;
	 case (0xf300 >> 6):
		// %1111_001100_mmmrrr	FSAVE <ea>
		OP_FUNC(fsave);
		break;
	 case (0xf340 >> 6):
		// %1111_001101_mmmrrr	FRESTORE <ea>
		OP_FUNC(frestore);
		break;
	 case (0xf400 >> 6):
	 case (0xf440 >> 6):
	 case (0xf480 >> 6):
	 case (0xf4c0 >> 6):
		// %1111_0100nn_001yyy	CINVL <caches>,(Ay)
		// %1111_0100nn_010yyy	CINVP <caches>,(Ay)
		// %1111_0100nn_011000	CINVA <caches>
		// %1111_0100nn_101yyy	CPUSHL <caches>,(Ay)
		// %1111_0100nn_110yyy	CPUSHP <caches>,(Ay)
		// %1111_0100nn_111000	CPUSHA <caches>
		OP_FUNC(cinv);
		break;
	 case (0xf500 >> 6):
		// %1111_010100_mmmrrr	cpSAVE
		// %1111_010100_000yyy	PFLUSHN (Ay)
		// %1111_010100_001yyy	PFLUSH (Ay)
		// %1111_010100_010000	PFLUSHAN
		// %1111_010100_011000	PFLUSHA
		OP_FUNC(pflush);
		break;
	 case (0xf540 >> 6):
		// %1111_010101_mmmrrr	cpRESTORE
		// %1111_010101_001yyy	PTESTW (Ay)
		// %1111_010101_101yyy	PTESTR (Ay)
		OP_FUNC(ptest);
		break;
	 case (0xf580 >> 6):
	 case (0xf5c0 >> 6):
		// %1111_010110_001nnn	PLPAW (An)
		// %1111_010111_001nnn	PLPAR (An)
		OP_FUNC(plpa);
		break;
	 case (0xf600 >> 6):
		// %1111_011000_000yyy	MOVE16 (Ay)+,xxx.L
		// %1111_011000_001yyy	MOVE16 xxx.L,(Ay)+
		// %1111_011000_010yyy	MOVE16 (Ay),xxx.L
		// %1111_011000_011yyy	MOVE16 xxx.L,(Ay)
		// %1111_011000_100yyy	MOVE16 (Ay)+,(An)+
		OP_FUNC(move16);
		break;
	 case (0xf700 >> 6):
	 case (0xf900 >> 6):
	 case (0xfb00 >> 6):
	 case (0xfd00 >> 6):
	 case (0xff00 >> 6):
		// %1111_011100_mmmrrr	cpSAVE
		// %1111_100100_mmmrrr	cpSAVE
		// %1111_101100_mmmrrr	cpSAVE
		// %1111_110100_mmmrrr	cpSAVE
		// %1111_111100_mmmrrr	cpSAVE
		OP_FUNC(cpsave);
		break;
	 case (0xf740 >> 6):
	 case (0xf940 >> 6):
	 case (0xfb40 >> 6):
	 case (0xfd40 >> 6):
	 case (0xff40 >> 6):
		// %1111_011101_mmmrrr	cpRESTORE
		// %1111_100101_mmmrrr	cpRESTORE
		// %1111_101101_mmmrrr	cpRESTORE
		// %1111_110101_mmmrrr	cpRESTORE
		// %1111_111101_mmmrrr	cpRESTORE
		OP_FUNC(cprestore);
		break;
	 case (0xf800 >> 6):
		// %1111_100000_000000	LPSTOP
		OP_FUNC(lpstop);
		break;
	 case (0x1040 >> 6):
	 case (0x1240 >> 6):
	 case (0x1440 >> 6):
	 case (0x15c0 >> 6):
	 case (0x1640 >> 6):
	 case (0x17c0 >> 6):
	 case (0x1840 >> 6):
	 case (0x19c0 >> 6):
	 case (0x1a40 >> 6):
	 case (0x1bc0 >> 6):
	 case (0x1c40 >> 6):
	 case (0x1dc0 >> 6):
	 case (0x1e40 >> 6):
	 case (0x1fc0 >> 6):
	 case (0x25c0 >> 6):
	 case (0x27c0 >> 6):
	 case (0x29c0 >> 6):
	 case (0x2bc0 >> 6):
	 case (0x2dc0 >> 6):
	 case (0x2fc0 >> 6):
	 case (0x35c0 >> 6):
	 case (0x37c0 >> 6):
	 case (0x39c0 >> 6):
	 case (0x3bc0 >> 6):
	 case (0x3dc0 >> 6):
	 case (0x3fc0 >> 6):
	 case (0x4140 >> 6):
	 case (0x4340 >> 6):
	 case (0x4540 >> 6):
	 case (0x4740 >> 6):
	 case (0x4940 >> 6):
	 case (0x4b40 >> 6):
	 case (0x4d40 >> 6):
	 case (0x4e00 >> 6):
	 case (0x4f40 >> 6):
	 case (0x7100 >> 6):
	 case (0x7140 >> 6):
	 case (0x7180 >> 6):
	 case (0x71c0 >> 6):
	 case (0x7300 >> 6):
	 case (0x7340 >> 6):
	 case (0x7380 >> 6):
	 case (0x73c0 >> 6):
	 case (0x7500 >> 6):
	 case (0x7540 >> 6):
	 case (0x7580 >> 6):
	 case (0x75c0 >> 6):
	 case (0x7700 >> 6):
	 case (0x7740 >> 6):
	 case (0x7780 >> 6):
	 case (0x77c0 >> 6):
	 case (0x7900 >> 6):
	 case (0x7940 >> 6):
	 case (0x7980 >> 6):
	 case (0x79c0 >> 6):
	 case (0x7b00 >> 6):
	 case (0x7b40 >> 6):
	 case (0x7b80 >> 6):
	 case (0x7bc0 >> 6):
	 case (0x7d00 >> 6):
	 case (0x7d40 >> 6):
	 case (0x7d80 >> 6):
	 case (0x7dc0 >> 6):
	 case (0x7f00 >> 6):
	 case (0x7f40 >> 6):
	 case (0x7f80 >> 6):
	 case (0x7fc0 >> 6):
	 case (0xf380 >> 6):
	 case (0xf3c0 >> 6):
	 case (0xf640 >> 6):
	 case (0xf680 >> 6):
	 case (0xf6c0 >> 6):
	 case (0xf780 >> 6):
	 case (0xf7c0 >> 6):
	 case (0xf840 >> 6):
	 case (0xf880 >> 6):
	 case (0xf8c0 >> 6):
	 case (0xf980 >> 6):
	 case (0xf9c0 >> 6):
	 case (0xfa00 >> 6):
	 case (0xfa40 >> 6):
	 case (0xfa80 >> 6):
	 case (0xfac0 >> 6):
	 case (0xfb80 >> 6):
	 case (0xfbc0 >> 6):
	 case (0xfc00 >> 6):
	 case (0xfc40 >> 6):
	 case (0xfc80 >> 6):
	 case (0xfcc0 >> 6):
	 case (0xfd80 >> 6):
	 case (0xfdc0 >> 6):
	 case (0xfe00 >> 6):
	 case (0xfe40 >> 6):
	 case (0xfe80 >> 6):
	 case (0xfec0 >> 6):
	 case (0xff80 >> 6):
	 case (0xffc0 >> 6):
		OP_FUNC(illegal);
		break;
