#
# nono
# Copyright (C) 2020 nono project
# Licensed under nono-license.txt
#

#
# xgettext の出力を整形する
#

# ヘッダをこっちのものに差し替える
for ($i = 0; $i < 5; $i++) {
	<>;
}
print "#\n";
print "# nono\n";
print "# Copyright (C) 2020 nono project\n";
print "# Licensed under nono-license.txt\n";
print "#\n";
print "\n";

# コメント中のファイル名はほしいけど行番号はいらない
$in_comment = 0;
$buffered = "";
for ($lines = 0; <>; $lines++) {
	if ($in_comment == 0) {
		# 地文中
		if (/^#: (.*)/) {
			# コメントが来た
			$in_comment = 1;
			$buffered = $1;
		} else {
			# 地文の続き
			print $_;
		}
	} else {
		# コメント中
		if (/^#: (.*)/) {
			# コメント継続
			$buffered .= " $1";
		} else {
			# コメント終わり
			$in_comment = 0;
			$orig = $_;

			# ここまでに出てきたファイル名を uniq | sort
			$buffered =~ s/:\d+//g;
			my @list = split(/\s+/, $buffered);
			my @list2 = ();
			my $prev = "";
			foreach my $f (sort @list) {
				if ($f ne $prev) {
					push @list2, $f;
					$prev = $f;
				}
			}

			# 出力 (手抜きにより行折り返しは考慮しない)
			print "#:";
			foreach my $f (@list2) {
				print " $f";
			}
			print "\n";

			print $orig;
		}
	}
}
