#!/usr/bin/env perl

#
# nono
# Copyright (C) 2023 nono project
# Licensed under nono-license.txt
#

# z80-asm の出力する .z80 形式を C ソースに変換して標準出力に出力する。
#
# usage: z80toc.pl <infile.z80> [<outfile.c>]

{
	$filename = $ARGV[0];
	$filesize = -s $filename;

	if (@ARGV > 1) {
		$outfile = $ARGV[1];
	} else {
		$outfile = $filename;
		$outfile =~ s/(\.z80|)$/.c/;
	}

	# ファイルを全部読み込む
	open(IN, $filename) or die;
	binmode(IN);
	read(IN, $magic, 8);
	read(IN, $dummylen, 2);
	read(IN, $data, $filesize - 10);
	close(IN);

	# マジック照合
	if ($magic != "Z80ASM\x1a\x0a") {
		die("${filename} is not z80-asm .z80 object format");
	}

	$varname = $filename;
	$varname =~ s/\.z80$//;

	# 出力
	open(OUT, ">$outfile") or die;
	printf OUT "int ${varname}_datalen = %d;\n", length($data);
	print OUT "const unsigned char ${varname}_data[] = {\n";
	$i = 0;
	for (; $i < length($data); $i++) {
		if ($i % 8 == 0) {
			print OUT "\t";
		}
		$ch = ord(substr($data, $i, 1));
		printf OUT "0x%02x,", $ch;
		if ($i % 8 != 7) {
			print OUT " ";
		} else {
			print OUT "\n";
		}
	}
	if ($i % 8 != 0) {
		print OUT "\n";
	}
	print OUT "};\n";
}
