//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// virt-m68k の I/O 空間担当
//

#pragma once

#include "device.h"
#include <array>

class V68kIODevice : public IODevice
{
	using inherited = IODevice;
 public:
	V68kIODevice();
	~V68kIODevice() override;

	bool Create() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

 private:
	inline IODevice *SearchDevice(uint32 addr) const;

	std::unique_ptr<IODevice> pGFPIC1 {};
	std::unique_ptr<IODevice> pGFPIC2 {};
	std::unique_ptr<IODevice> pGFPIC3 {};
	std::unique_ptr<IODevice> pGFPIC4 {};
	std::unique_ptr<IODevice> pGFPIC5 {};
	std::unique_ptr<IODevice> pGFPIC6 {};
	std::unique_ptr<IODevice> pGFTimer {};
	std::unique_ptr<IODevice> pGFRTC {};
	std::unique_ptr<IODevice> pGFTTY {};
	std::unique_ptr<IODevice> pPROM {};
	std::unique_ptr<IODevice> pQemuSysCtlr {};
	std::unique_ptr<IODevice> pVirtIONone {};
	std::array<std::unique_ptr<IODevice>, 128> pVirtIO {};

	IODevice *buserr {};

	// メインテーブル。
	// $ff00'xxxx から $1000 ずつ、当面 $ff07'0000 (の手前) まで。
	std::array<IODevice*, 7 * 16> table {};

	// VirtIO 用スロット。
	std::array<IODevice*, 128> viotable {};
};

inline V68kIODevice *GetV68kIODevice() {
	return Object::GetObject<V68kIODevice>(OBJ_V68KIO);
}
