//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// メイン画面パネル
//

#pragma once

#include "wxnono.h"

wxDECLARE_EVENT(NONO_EVT_MOUSEMODE, wxCommandEvent);

class DumbKeyboard;
class Keyboard;
class VideoRenderer;

class WXMainView : public wxPanel
{
	using inherited = wxPanel;
 public:
	explicit WXMainView(wxWindow *);
	~WXMainView() override;

	bool Init();

	void Close();
	void DoResize(double scale);

	// 現在のスケールを返す
	double GetScale() const;
	// 現在のスケール (wxapp が初期値を指定するため static 変数にしてある)
	static double screen_scale;

	// 文字入力モードを取得・設定
	bool GetCharInputMode() const { return is_charinput; }
	void SetCharInputMode(bool enable);

	// マウスモードを設定
	void SetMouseMode(bool enable);
	// マウスモードを取得 (キャプチャされているなら true)
	bool GetMouseMode() const { return mousemode; }
	// アクティベートイベント
	void OnActivate(wxActivateEvent& event);

	// キー入力イベント (WXSoftKeyPanel からも呼ばれる)
	void OnKeyDown(wxKeyEvent& event);
	void OnKeyUp(wxKeyEvent& event);
	void OnChar(wxKeyEvent& event);

 private:
	void OnTimer(wxTimerEvent& event);
	void OnPaint(wxPaintEvent& event);
	void OnMouse(wxMouseEvent& event);
	void OnMouseCaptureLost(wxMouseCaptureLostEvent& event);
	void OnRender(wxCommandEvent& event);
	void OnMouseMode(wxCommandEvent& event);

	// 実画面サイズ (ピクセル)
	int viewwidth {};
	int viewheight {};

	// 共通キーコードを取得する
	int GetKeyCode(wxKeyEvent& event);

	static const int keycode_table[0x190];

	// 文字入力モードなら true
	bool is_charinput {};

	// マウスモード (キャプチャしていれば true)
	bool mousemode {};
	// 前回のマウス座標とボタン
	wxPoint prevpos {};
	bool prevlb {};
	bool prevmb {};
	bool prevrb {};

	// WarpPointer() による移動検出用
	bool motion_by_warp_pointer {};
	// マウスカーソルを移動させる
	void MyWarpPointer(wxSize pos);

	DumbKeyboard *dumbkbd {};
	Keyboard *richkbd {};
	VideoRenderer *renderer {};

	wxDECLARE_EVENT_TABLE();
};
