local variants = require 'i18n.variants'

describe("i18n.variants", function()
  it("is a table", function()
    assert.equal('table', type(variants))
  end)

  describe(".ancestry", function()
    it("returns just the locale for simple locales", function()
      assert.same(variants.ancestry('en'), {'en'})
    end)

    it("returns self and parents for composite locales", function()
      assert.same(variants.ancestry('en-US-texas'), {'en-US-texas', 'en-US', 'en'})
    end)
  end)

  describe(".isParent", function()
    it("works as expected", function()
      assert.is_true(variants.isParent('en', 'en-US'))
      assert.is_false(variants.isParent('en-US', 'en'))
      assert.is_false(variants.isParent('en', 'fr'))
      assert.is_false(variants.isParent('en', 'english'))
      assert.is_false(variants.isParent('en', 'en'))
    end)
  end)

  describe(".root", function()
    it("returns just the locale for simple locales", function()
      assert.equal('en', variants.root('en'))
    end)
    it("returns the root for composite locales", function()
      assert.equal('en', variants.root('en-US'))
    end)
  end)

  describe(".fallbacks", function()
    describe("when given locales of the same ancestry", function()
      it("returns the locale ancestry if given exactly the same locale twice", function()
        assert.same(variants.fallbacks('en-US','en-US'), {'en-US', 'en'})
      end)
      it("returns the locale ancestry if fallbackLocale is parent of locale", function()
        assert.same(variants.fallbacks('en-US','en'), {'en-US', 'en'})
      end)
      it("returns the fallbackLocale ancestry if locale is parent of fallbackLocale", function()
        assert.same(variants.fallbacks('en','en-US'), {'en-US', 'en'})
      end)
    end)
    describe("when given two different locales", function()
      it("returns the first locale first, followed by the fallback locale ancestry", function()
        assert.same(variants.fallbacks('fr-CA', 'en-US'), {'fr-CA', 'fr', 'en-US', 'en'})
      end)
    end)
  end)
end)
