# OPA Community Guidelines v2.0

The [CNCF Code of Conduct](https://github.com/cncf/foundation/blob/master/code-of-conduct.md) is enforced in all areas of the OPA community, plus the following.

## Relevancy 

Any content posted or shared in the OPA community should be relevant to the specific Slack Channel or GitHub Category, and generally to the OPA community. If you're unsure about the content you want to share, posting in #help channel in Slack or the Community category in GitHub Discussions is always a safe choice; admins will be around to help guide new members. 

## Spamming

Excessive re-posting, unnecessary cross-posting, unsolicited advertisements for services or products are not allowed on any of the OPA communication channels and are considered spam. Posting content that is considered spam will be removed and these actions are subject to the same enforcement rules as unacceptable behavior.

## Vendors

The OPA community has a rich ecosystem of tools, integrations, and Vendors to support them. Any company whose primary revenue stream includes a cloud-native service or technology is considered a Vendor. As a valuable part of the OPA ecosystem Vendors are encouraged to participate in the community with the expectation that they have good intentions, this means interacting with members with the intent to be helpful and supportive. Any unsolicited advertisements will be removed and are subject to our enforcement rules.

## End-users

Companies that use cloud-native services internally, but do not sell any of these services externally, are considered an End User Company in the OPA Community. End User companies are expected to operate with positive intentions, this is not the place to build your marketing funnel for external tools and services. 

## Member Participation

The OPA community is here for everyone to connect with one another, share information, and build amazing products. By choosing to participate in the OPA community as a Vendor, End User, or general contributor you are agreeing to respect these guidelines. When interacting with any of our social channels, Slack, Twitter, GitHub, and any other channels we participate in, there is an expectation that you will exhibit the values of the OPA community.

## Values

### Be Respectful

Value each other’s ideas, styles and viewpoints. We may not always agree, but disagreement is no excuse for poor manners. Be open to different possibilities and to being wrong. Be respectful in all interactions and communications, especially when debating the merits of different options. Be aware of your impact and how intense interactions may be affecting people. Be direct, constructive and positive. Take responsibility for your impact and your mistakes – if someone says they have been harmed through your words or actions, listen carefully, apologize sincerely, and correct the behavior going forward.

### Be Direct but Professional

We are likely to have some discussions about if and when criticism is respectful and when it’s not. We must be able to speak directly when we disagree and when we think we need to improve. We cannot withhold hard truths. Doing so respectfully is hard, doing so when others don’t seem to be listening is harder, and hearing such comments when one is the recipient can be even harder still. We need to be honest and direct, as well as respectful.

### Be Inclusive

Seek diverse perspectives. Diversity of views and of people on teams powers innovation, even if it is not always comfortable. Encourage all voices. Help new perspectives be heard and listen actively. If you find yourself dominating a discussion, it is especially important to step back and encourage other voices to join in. Be aware of how much time is taken up by dominant members of the group. Provide alternative ways to contribute or participate when possible.

Be inclusive of everyone in an interaction, respecting and facilitating people’s participation whether they are:

- Remote (on video or phone)
- Not native language speakers
- Coming from a different culture
- Using pronouns other than “he” or “she”
- Living in a different time zone
- Facing other challenges to participate
- Think about how you might facilitate alternative ways to contribute or participate. If you find yourself dominating a discussion, step back. Make way for other voices and listen actively to them.

> These values were inspired by the [Mozilla Community Participation Guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/)

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior will not be tolerated. An admin may take any action deemed appropriate, up to and including, a warning, a temporary ban(30 days), and a permanent ban for repeated violation of these guidelines. Admins may also remove content that violates the guidelines.


## Reporting

Please reach out to one of the admins below, or use the anonymous feedback form. 

- Anders Eknert (a_eknert@apple.com or @anderseknert)
- Torin Sandall (torinsandall@gmail.com or @tsandall) 
- Amye Scavarda Parrin (amye@linuxfoundation.org)
- Anonymous Feedback: https://forms.gle/vFkrC1jMai1q3EZY6
