# pyformlang

[![Python package](https://github.com/Aunsiels/pyformlang/actions/workflows/python-package.yml/badge.svg)](https://github.com/Aunsiels/pyformlang/actions/workflows/python-package.yml)
[![pypi](https://img.shields.io/pypi/v/pyformlang.svg)](https://pypi.org/project/pyformlang/)
[![Documentation](https://readthedocs.org/projects/pyformlang/badge/?version=latest)](https://pyformlang.readthedocs.io/en/latest/)
![badge](https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/Aunsiels/135f01c630063c3e69d999a2edf59fdb/raw/coverage_pyformlang.json)


A python library to manipulate formal grammar. In general, it can be used to better understand algorithms in a formal way.

If you use Pyformlang in your project, please cite our paper:

```
@InProceedings{pyformlang,
author="Romero, Julien",
title="Pyformlang: An Educational Library for Formal Language Manipulation",
booktitle="SIGCSE",
year="2021"
doi = {https://doi.org/10.1145/3408877.3432464}
}
```

## Installation

```bash
pip3 install pyformlang
```

## Sources

Most algorithms come from Introduction to *Automata Theory, Languages, and Computation*
(2nd edition) by John E. Hopcroft, Rajeev Motwani and Jeferey D. Ullman.

Indexed grammars come from the original paper *Index Grammars - An Extension of Context-free grammars* by Alfred V. Aho.

On the implementation of Hopcroft minimization algorithm: [Implementation of Hopcroft's Algorithm, Hang Zhou](https://www.irif.fr/~carton/Enseignement/Complexite/ENS/Redaction/2009-2010/hang.zhou.pdf)

[Intersection CFG/Regex](https://www.degruyter.com/downloadpdf/j/stuf.1961.14.issue-1-4/stuf.1961.14.14.143/stuf.1961.14.14.143.pdf) and [a better written version](http://www.cs.umd.edu/~gasarch/BLOGPAPERS/cfg.pdf)

## Usage

Please refer to the official documentation: [pyformlang.readthedocs.io](https://pyformlang.readthedocs.io).

