import CoreServices
from PyObjCTools.TestSupport import TestCase


class TestUnicodeConvertor(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), f"{name!r} exposed in bindings"
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("TextToUnicodeInfo")
        self.assert_not_wrapped("UnicodeToTextInfo")
        self.assert_not_wrapped("UnicodeToTextRunInfo")
        self.assert_not_wrapped("kUnicodeUseLatestMapping")
        self.assert_not_wrapped("kUnicodeUseHFSPlusMapping")
        self.assert_not_wrapped("kUnicodeUseFallbacksBit")
        self.assert_not_wrapped("kUnicodeKeepInfoBit")
        self.assert_not_wrapped("kUnicodeDirectionalityBits")
        self.assert_not_wrapped("kUnicodeVerticalFormBit")
        self.assert_not_wrapped("kUnicodeLooseMappingsBit")
        self.assert_not_wrapped("kUnicodeStringUnterminatedBit")
        self.assert_not_wrapped("kUnicodeTextRunBit")
        self.assert_not_wrapped("kUnicodeKeepSameEncodingBit")
        self.assert_not_wrapped("kUnicodeForceASCIIRangeBit")
        self.assert_not_wrapped("kUnicodeNoHalfwidthCharsBit")
        self.assert_not_wrapped("kUnicodeTextRunHeuristicsBit")
        self.assert_not_wrapped("kUnicodeMapLineFeedToReturnBit")
        self.assert_not_wrapped("kUnicodeUseExternalEncodingFormBit")
        self.assert_not_wrapped("kUnicodeUseFallbacksMask")
        self.assert_not_wrapped("kUnicodeKeepInfoMask")
        self.assert_not_wrapped("kUnicodeDirectionalityMask")
        self.assert_not_wrapped("kUnicodeVerticalFormMask")
        self.assert_not_wrapped("kUnicodeLooseMappingsMask")
        self.assert_not_wrapped("kUnicodeStringUnterminatedMask")
        self.assert_not_wrapped("kUnicodeTextRunMask")
        self.assert_not_wrapped("kUnicodeKeepSameEncodingMask")
        self.assert_not_wrapped("kUnicodeForceASCIIRangeMask")
        self.assert_not_wrapped("kUnicodeNoHalfwidthCharsMask")
        self.assert_not_wrapped("kUnicodeTextRunHeuristicsMask")
        self.assert_not_wrapped("kUnicodeMapLineFeedToReturnMask")
        self.assert_not_wrapped("kUnicodeUseExternalEncodingFormMask")
        self.assert_not_wrapped("kUnicodeDefaultDirection")
        self.assert_not_wrapped("kUnicodeLeftToRight")
        self.assert_not_wrapped("kUnicodeRightToLeft")
        self.assert_not_wrapped("kUnicodeDefaultDirectionMask")
        self.assert_not_wrapped("kUnicodeLeftToRightMask")
        self.assert_not_wrapped("kUnicodeRightToLeftMask")
        self.assert_not_wrapped("kUnicodeMatchUnicodeBaseBit")
        self.assert_not_wrapped("kUnicodeMatchUnicodeVariantBit")
        self.assert_not_wrapped("kUnicodeMatchUnicodeFormatBit")
        self.assert_not_wrapped("kUnicodeMatchOtherBaseBit")
        self.assert_not_wrapped("kUnicodeMatchOtherVariantBit")
        self.assert_not_wrapped("kUnicodeMatchOtherFormatBit")
        self.assert_not_wrapped("kUnicodeMatchUnicodeBaseMask")
        self.assert_not_wrapped("kUnicodeMatchUnicodeVariantMask")
        self.assert_not_wrapped("kUnicodeMatchUnicodeFormatMask")
        self.assert_not_wrapped("kUnicodeMatchOtherBaseMask")
        self.assert_not_wrapped("kUnicodeMatchOtherVariantMask")
        self.assert_not_wrapped("kUnicodeMatchOtherFormatMask")
        self.assert_not_wrapped("kUnicodeFallbackSequencingBits")
        self.assert_not_wrapped("kUnicodeFallbackDefaultOnly")
        self.assert_not_wrapped("kUnicodeFallbackCustomOnly")
        self.assert_not_wrapped("kUnicodeFallbackDefaultFirst")
        self.assert_not_wrapped("kUnicodeFallbackCustomFirst")
        self.assert_not_wrapped("NewUnicodeToTextFallbackUPP")
        self.assert_not_wrapped("DisposeUnicodeToTextFallbackUPP")
        self.assert_not_wrapped("InvokeUnicodeToTextFallbackUPP")
        self.assert_not_wrapped("CreateTextToUnicodeInfo")
        self.assert_not_wrapped("CreateTextToUnicodeInfoByEncoding")
        self.assert_not_wrapped("CreateUnicodeToTextInfo")
        self.assert_not_wrapped("CreateUnicodeToTextInfoByEncoding")
        self.assert_not_wrapped("CreateUnicodeToTextRunInfo")
        self.assert_not_wrapped("CreateUnicodeToTextRunInfoByEncoding")
        self.assert_not_wrapped("CreateUnicodeToTextRunInfoByScriptCode")
        self.assert_not_wrapped("ChangeTextToUnicodeInfo")
        self.assert_not_wrapped("ChangeUnicodeToTextInfo")
        self.assert_not_wrapped("DisposeTextToUnicodeInfo")
        self.assert_not_wrapped("DisposeUnicodeToTextInfo")
        self.assert_not_wrapped("DisposeUnicodeToTextRunInfo")
        self.assert_not_wrapped("ConvertFromTextToUnicode")
        self.assert_not_wrapped("ConvertFromUnicodeToText")
        self.assert_not_wrapped("ConvertFromUnicodeToTextRun")
        self.assert_not_wrapped("ConvertFromUnicodeToScriptCodeRun")
        self.assert_not_wrapped("TruncateForTextToUnicode")
        self.assert_not_wrapped("TruncateForUnicodeToText")
        self.assert_not_wrapped("ConvertFromPStringToUnicode")
        self.assert_not_wrapped("ConvertFromUnicodeToPString")
        self.assert_not_wrapped("CountUnicodeMappings")
        self.assert_not_wrapped("QueryUnicodeMappings")
        self.assert_not_wrapped("SetFallbackUnicodeToText")
        self.assert_not_wrapped("SetFallbackUnicodeToTextRun")
        self.assert_not_wrapped("ResetTextToUnicodeInfo")
        self.assert_not_wrapped("ResetUnicodeToTextInfo")
        self.assert_not_wrapped("ResetUnicodeToTextRunInfo")
