# MD043 - Enforce Required Document Structure

Aliases: `required-headings`

## What this rule does

Ensures your documents contain specific required headings, helping maintain consistent structure across documentation sets.

## Why this matters

- **Consistent documentation**: All documents follow the same organizational pattern
- **Complete information**: Ensures important sections aren't forgotten
- **Better navigation**: Readers know where to find specific information
- **Team alignment**: Everyone follows the same documentation template

## Examples

### ✅ Correct

With required headings configuration:

```toml
[MD043]
headings = ["# Overview", "## Installation", "## Usage", "## License"]
```

```markdown
# Overview

This tool helps you lint Markdown files...

## Installation

Install using npm:

## Usage

Run the following command...

## License

MIT License
```

### ❌ Incorrect

```markdown
# Getting Started              <!-- Wrong heading text -->

This tool helps you...

## How to Install             <!-- Should be "Installation" -->

Install using npm...

## Examples                   <!-- Should be "Usage" -->

Run the following...

## License

MIT License
```

### 🔧 Fixed

```markdown
# Overview                    <!-- Corrected heading -->

This tool helps you...

## Installation              <!-- Corrected heading -->

Install using npm...

## Usage                     <!-- Corrected heading -->

Run the following...

## License

MIT License
```

## Configuration

```toml
[MD043]
headings = []      # Required heading patterns (empty disables the rule)
match-case = false  # Case-sensitive matching (default: false)
```

### Wildcard Patterns

The `headings` configuration supports three wildcard patterns for flexible document structures:

#### `*` - Zero or More Headings

Matches any number of headings (including zero). Use this for optional sections that may or may not appear.

```toml
[MD043]
headings = ["# Project", "*", "## License"]
```

This allows:

- `# Project` → `## License` (no sections in between)
- `# Project` → `## Features` → `## Usage` → `## License` (multiple sections)

#### `+` - One or More Headings

Requires at least one heading but allows multiple. Use this when content is required but flexible.

```toml
[MD043]
headings = ["# Documentation", "+", "## Contributing"]
```

This requires:

- At least one section between "Documentation" and "Contributing"
- Multiple sections are allowed

#### `?` - Exactly One Heading

Matches exactly one heading without specifying its content. Ideal for variable content like project names.

```toml
[MD043]
headings = ["?", "## Description", "## Installation"]
```

This requires:

- Exactly one heading (any text) before "Description"
- Useful for project READMEs where the title varies

### Advanced Wildcard Examples

**Flexible open source documentation:**

```toml
[MD043]
headings = [
  "?",                  # Project name (variable)
  "## Overview",        # Required
  "*",                  # Optional sections (badges, features, etc.)
  "## Installation",    # Required
  "*",                  # Optional sections (usage, examples, etc.)
  "## License"          # Required
]
```

**API documentation with variable endpoints:**

```toml
[MD043]
headings = [
  "# API Reference",
  "+",                  # One or more endpoint sections
  "## Error Codes",
  "## Rate Limiting"
]
```

## Automatic fixes

When enabled, this rule will:

- Identify heading structure mismatches
- Preserve original content to prevent data loss
- Support wildcard patterns for flexible matching

**Note:** Automatic fixes for this rule are conservative to avoid destructive changes.

## Special cases

- Empty configuration disables this rule
- Wildcards (`*`, `+`, `?`) provide flexible pattern matching
- Order of headings matters - patterns are matched sequentially
- Case sensitivity controlled by `match_case` option
- All wildcards pattern (e.g., `["*"]`) allows any structure

## Learn more

- [Documentation templates best practices](https://www.writethedocs.org/guide/writing/docs-principles/)
- [Structured documentation guide](https://documentation.divio.com/)

## Related rules

- [MD001](md001.md) - Keep heading levels organized
- [MD003](md003.md) - Use consistent heading styles
- [MD025](md025.md) - Use only one main title
