# MD029 - Use consistent numbers for ordered lists

Aliases: `ol-prefix`

## What this rule does

Ensures ordered lists use consistent numbering - either all "1." (letting Markdown handle numbering) or sequential numbers (1, 2, 3).

## Why this matters

- **Easier maintenance**: Using all "1." means you can reorder items without renumbering
- **Clear intent**: Consistent numbering shows whether order matters
- **Better diffs**: All "1." creates cleaner version control diffs when reordering
- **Predictable rendering**: Prevents confusion about how lists will be numbered

## Examples

### ✅ Correct (one style - recommended)

```markdown
1. First item
1. Second item
1. Third item
```

### ✅ Correct (ordered style)

```markdown
1. First item
2. Second item
3. Third item
```

### ❌ Incorrect

<!-- rumdl-disable MD029 -->

```markdown
1. First item
3. Second item
5. Third item
```

<!-- rumdl-enable MD029 -->

### 🔧 Fixed

```markdown
1. First item
1. Second item
1. Third item
```

## Configuration

```toml
[MD029]
# Style options:
# - "one" or "one-one": All items numbered "1." (easiest maintenance)
# - "ordered": Sequential numbering (1, 2, 3...)
# - "ordered0": Zero-based sequential (0, 1, 2...)
# - "one-or-ordered": Auto-detect per list (either all-ones OR sequential)
# - "consistent": Document-wide consistency - uses most common style across all lists
style = "one-or-ordered"  # Default - matches markdownlint behavior
```

### Style Modes Explained

**Explicit styles** (`one`, `ordered`, `ordered0`):

- All lists must use the specified style
- Best when you have a strong preference for a specific numbering style

**`one-or-ordered` (default)**:

- Each list can be either all-ones OR sequential
- Per-list validation - different lists can use different styles
- Matches markdownlint behavior
- Good for flexibility while preventing mixed numbering within a list

**`consistent`**:

- Document-wide consistency - all lists must use the same style
- Automatically detects the most common style across all lists
- The majority style wins - minority lists are flagged
- Best for enforcing consistency across large documents

#### Example: `consistent` mode

```markdown
<!-- rumdl-disable MD029 -->

List 1 (sequential - majority):
1. First
2. Second
3. Third

List 2 (one style - will be flagged):
1. First
1. Second
1. Third

List 3 (sequential - matches majority):
1. Alpha
2. Beta
3. Gamma
```

<!-- rumdl-enable MD029 -->

With `style = "consistent"`, List 2 would be flagged because sequential (1,2,3) is the document's prevalent style (2 out of 3 lists).

## Automatic fixes

This rule will:

- Renumber all list items according to your chosen or detected style
- Preserve list item content and indentation
- Handle nested lists independently

## Learn more

- [CommonMark Spec: List items](https://spec.commonmark.org/0.31.2/#list-items)
- [CommonMark Spec: Lists](https://spec.commonmark.org/0.31.2/#lists)

## Related rules

- [MD004 - Use consistent list markers](md004.md)
- [MD005 - Keep list indentation consistent](md005.md)
- [MD007 - Indent lists properly](md007.md)
- [MD030 - Add spaces after list markers](md030.md)
