<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw help`
Get help about how the CLI works
  
- [Get help about how date parsing works in the CLI](#get-help-about-how-date-parsing-works-in-the-cli)
- [Get help about how the CLI output works](#get-help-about-how-the-cli-output-works)

  
## Get help about how date parsing works in the CLI

Date parsing

You have two ways for managing date in the CLI: Absolute and Relative

- Absolute time

  Absolute time refers to a specific and absolute point in time.
  CLI uses RFC3339 to parse those time and pass a time.Time go structure to the underlying functions.

	Example: "2006-01-02T15:04:05Z07:00"

- Relative time

  Relative time refers to a time calculated from adding a given duration to the time when a command is launched.

	Example:
	- +1d4m => current time plus 1 day and 4 minutes
	- -1d4m => current time minus 1 day and 4 minutes

- Units of time

	Nanosecond: ns
	Microsecond: us, µs (U+00B5 = micro symbol), μs (U+03BC = Greek letter mu)
	Millisecond: ms
	Second: s, sec, second, seconds
	Minute: m, min, minute, minutes
	Hour: h, hr, hour, hours
	Day: d, day, days
	Week: w, wk, week, weeks
	Month: mo, mon, month, months
	Year: y, yr, year, years


Date parsing

You have two ways for managing date in the CLI: Absolute and Relative

- Absolute time

  Absolute time refers to a specific and absolute point in time.
  CLI uses RFC3339 to parse those time and pass a time.Time go structure to the underlying functions.

	Example: "2006-01-02T15:04:05Z07:00"

- Relative time

  Relative time refers to a time calculated from adding a given duration to the time when a command is launched.

	Example:
	- +1d4m => current time plus 1 day and 4 minutes
	- -1d4m => current time minus 1 day and 4 minutes

- Units of time

	Nanosecond: ns
	Microsecond: us, µs (U+00B5 = micro symbol), μs (U+03BC = Greek letter mu)
	Millisecond: ms
	Second: s, sec, second, seconds
	Minute: m, min, minute, minutes
	Hour: h, hr, hour, hours
	Day: d, day, days
	Week: w, wk, week, weeks
	Month: mo, mon, month, months
	Year: y, yr, year, years


**Usage:**

```
scw help date
```



## Get help about how the CLI output works

Output formatting in the CLI

Human output (default one)

	scw instance server list                       

	ID                                    NAME               TYPE    STATE    ZONE      PUBLIC IP
	088b01da-9ba7-40d2-bc55-eb3170f42185  scw-cool-franklin  DEV1-S  running  fr-par-1  51.15.251.251

Human with column selection

You can select the columns that you want to print with commands that return a list 

	scw instance server list -o human=Name,PublicIP

	NAME                                            PUBLIC IP
	scw-cool-franklin                               51.15.251.251

Wide output (Human without column shrinking)

	scw instance server list -o wide

	ID                                    NAME               TYPE    STATE    ZONE      PUBLIC IP
	088b01da-9ba7-40d2-bc55-eb3170f42185  scw-cool-franklin  DEV1-S  running  fr-par-1  51.15.251.251

Wide with column selection

You can select the columns that you want to print with commands that return a list 

	scw instance server list -o wide=Name,PublicIP

	NAME                                            PUBLIC IP
	scw-cool-franklin                               51.15.251.251


Standard JSON output

	scw config dump -o json

	{"access_key":"SCWXXXXXXXXXXXXXXXXX","secret_key":"11111111-1111-1111-1111-111111111111","default_organization_id":"11111111-1111-1111-1111-111111111111","default_region":"fr-par","default_zone":"fr-par-1","send_telemetry":true}

Pretty JSON output

	scw config dump -o json=pretty

	{
	  "access_key": "SCWXXXXXXXXXXXXXXXXX",
	  "secret_key": "11111111-1111-1111-1111-111111111111",
	  "default_organization_id": "11111111-1111-1111-1111-111111111111",
	  "default_region": "fr-par",
	  "default_zone": "fr-par-1",
	  "send_telemetry": true
	}

Standard YAML output

	scw config dump -o yaml

	access_key: SCWXXXXXXXXXXXXXXXXX
	secret_key: 11111111-1111-1111-1111-111111111111
	default_organization_id: 11111111-1111-1111-1111-111111111111
	default_region: fr-par
	default_zone: fr-par-1
	send_telemetry: true


Template output

You can use Go template to manipulate the output of a command and create a custom rendering of your resources. 
Visit https://golang.org/pkg/text/template/ to learn more about Go template format.

	scw instance server list -o template="{{ .Name }}||{{ .ID }}"

	foo||11111111-1111-1111-1111-111111111111
	bar||22222222-2222-2222-2222-222222222222

In case the command returns data that is not correctly converted, for instance a []byte, you can use the json function to marshal the data as json and print it as is.

       scw instance server list -o template="{{ json . }}"


Output formatting in the CLI

Human output (default one)

	scw instance server list                       

	ID                                    NAME               TYPE    STATE    ZONE      PUBLIC IP
	088b01da-9ba7-40d2-bc55-eb3170f42185  scw-cool-franklin  DEV1-S  running  fr-par-1  51.15.251.251

Human with column selection

You can select the columns that you want to print with commands that return a list 

	scw instance server list -o human=Name,PublicIP

	NAME                                            PUBLIC IP
	scw-cool-franklin                               51.15.251.251

Wide output (Human without column shrinking)

	scw instance server list -o wide

	ID                                    NAME               TYPE    STATE    ZONE      PUBLIC IP
	088b01da-9ba7-40d2-bc55-eb3170f42185  scw-cool-franklin  DEV1-S  running  fr-par-1  51.15.251.251

Wide with column selection

You can select the columns that you want to print with commands that return a list 

	scw instance server list -o wide=Name,PublicIP

	NAME                                            PUBLIC IP
	scw-cool-franklin                               51.15.251.251


Standard JSON output

	scw config dump -o json

	{"access_key":"SCWXXXXXXXXXXXXXXXXX","secret_key":"11111111-1111-1111-1111-111111111111","default_organization_id":"11111111-1111-1111-1111-111111111111","default_region":"fr-par","default_zone":"fr-par-1","send_telemetry":true}

Pretty JSON output

	scw config dump -o json=pretty

	{
	  "access_key": "SCWXXXXXXXXXXXXXXXXX",
	  "secret_key": "11111111-1111-1111-1111-111111111111",
	  "default_organization_id": "11111111-1111-1111-1111-111111111111",
	  "default_region": "fr-par",
	  "default_zone": "fr-par-1",
	  "send_telemetry": true
	}

Standard YAML output

	scw config dump -o yaml

	access_key: SCWXXXXXXXXXXXXXXXXX
	secret_key: 11111111-1111-1111-1111-111111111111
	default_organization_id: 11111111-1111-1111-1111-111111111111
	default_region: fr-par
	default_zone: fr-par-1
	send_telemetry: true


Template output

You can use Go template to manipulate the output of a command and create a custom rendering of your resources. 
Visit https://golang.org/pkg/text/template/ to learn more about Go template format.

	scw instance server list -o template="{{ .Name }}||{{ .ID }}"

	foo||11111111-1111-1111-1111-111111111111
	bar||22222222-2222-2222-2222-222222222222

In case the command returns data that is not correctly converted, for instance a []byte, you can use the json function to marshal the data as json and print it as is.

       scw instance server list -o template="{{ json . }}"


**Usage:**

```
scw help output
```



