/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.AutoValue_BuildSdkApksForAppCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.DaggerBuildSdkApksForAppManagerComponent;
import com.android.tools.build.bundletool.commands.DebugKeystoreUtils;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.SdkAsar;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.sdkmodule.SdkModuleToAppBundleModuleConverter;
import com.android.tools.build.bundletool.validation.SdkAsarValidator;
import com.android.tools.build.bundletool.validation.SdkBundleValidator;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildSdkApksForAppCommand {
    private static final int DEFAULT_THREAD_POOL_SIZE = 4;
    public static final String COMMAND_NAME = "build-sdk-apks-for-app";
    private static final Flag<Path> SDK_BUNDLE_LOCATION_FLAG = Flag.path("sdk-bundle");
    private static final Flag<Path> SDK_ARCHIVE_LOCATION_FLAG = Flag.path("sdk-archive");
    private static final Flag<Path> INHERITED_APP_PROPERTIES_LOCATION_FLAG = Flag.path("app-properties");
    private static final Flag<Path> OUTPUT_FILE_FLAG = Flag.path("output");
    private static final Flag<Path> AAPT2_PATH_FLAG = Flag.path("aapt2");
    private static final Flag<Path> KEYSTORE_FLAG = Flag.path("ks");
    private static final Flag<String> KEY_ALIAS_FLAG = Flag.string("ks-key-alias");
    private static final Flag<Password> KEYSTORE_PASSWORD_FLAG = Flag.password("ks-pass");
    private static final Flag<Password> KEY_PASSWORD_FLAG = Flag.password("key-pass");
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    public abstract Optional<Path> getSdkBundlePath();

    public abstract Optional<Path> getSdkArchivePath();

    public abstract RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp getInheritedAppProperties();

    public abstract Path getOutputFile();

    public abstract Optional<Aapt2Command> getAapt2Command();

    public abstract Optional<SigningConfiguration> getSigningConfiguration();

    ListeningExecutorService getExecutorService() {
        return this.getExecutorServiceInternal();
    }

    abstract ListeningExecutorService getExecutorServiceInternal();

    abstract boolean isExecutorServiceCreatedByBundleTool();

    public static Builder builder() {
        return new AutoValue_BuildSdkApksForAppCommand.Builder();
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_BUNDLE_LOCATION_FLAG.getName()).setExampleValue("sdk.asb").setDescription("Path to SDK bundle to generate app-specific split APKs from. Can not be used together with the `sdk-archive` flag.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_ARCHIVE_LOCATION_FLAG.getName()).setExampleValue("sdk.asar").setDescription("Path to SDK archive to generate app-specific split APKs from. Can not be used together with the `sdk-bundle` flag.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(INHERITED_APP_PROPERTIES_LOCATION_FLAG.getName()).setExampleValue("config.json").setDescription("Path to the JSON config containing app properties that the SDK split should inherit.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FILE_FLAG.getName()).setExampleValue("output.apks").setDescription("Path to where the APK Set archive should be created.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(AAPT2_PATH_FLAG.getName()).setExampleValue("path/to/aapt2").setOptional(true).setDescription("Path to the aapt2 binary to use.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setOptional(true).setDescription("Path to the keystore that should be used to sign the generated APKs. If not set, the default debug keystore will be used if it exists. If not found the APKs will not be signed. If set, the flag '%s' must also be set.", KEY_ALIAS_FLAG).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_ALIAS_FLAG.getName()).setExampleValue("key-alias").setOptional(true).setDescription("Alias of the key to use in the keystore to sign the generated APKs.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_PASSWORD_FLAG.getName()).setExampleValue("key-password").setOptional(true).setDescription("Password of the key in the keystore to use to sign the generated APKs. If provided, must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).build();
    }

    public static BuildSdkApksForAppCommand fromFlags(ParsedFlags flags) {
        return BuildSdkApksForAppCommand.fromFlags(flags, System.out, DEFAULT_PROVIDER);
    }

    static BuildSdkApksForAppCommand fromFlags(ParsedFlags flags, PrintStream out, SystemEnvironmentProvider systemEnvironmentProvider) {
        Builder command = BuildSdkApksForAppCommand.builder().setInheritedAppProperties(INHERITED_APP_PROPERTIES_LOCATION_FLAG.getRequiredValue(flags)).setOutputFile(OUTPUT_FILE_FLAG.getRequiredValue(flags));
        SDK_BUNDLE_LOCATION_FLAG.getValue(flags).ifPresent(command::setSdkBundlePath);
        SDK_ARCHIVE_LOCATION_FLAG.getValue(flags).ifPresent(command::setSdkArchivePath);
        AAPT2_PATH_FLAG.getValue(flags).ifPresent(aapt2Path -> command.setAapt2Command(Aapt2Command.createFromExecutablePath(aapt2Path)));
        BuildSdkApksForAppCommand.populateSigningConfigurationFromFlags(command, flags, out, systemEnvironmentProvider);
        return command.build();
    }

    public void execute() {
        this.validateInput();
        if (this.getSdkBundlePath().isPresent()) {
            this.executeForSdkBundle();
        } else if (this.getSdkArchivePath().isPresent()) {
            this.executeForSdkArchive();
        } else {
            throw new IllegalStateException("whaaat");
        }
    }

    private void validateInput() {
        if (this.getSdkBundlePath().isPresent()) {
            FilePreconditions.checkFileExistsAndReadable(this.getSdkBundlePath().get());
            FilePreconditions.checkFileHasExtension("ASB file", this.getSdkBundlePath().get(), ".asb");
        }
        if (this.getSdkArchivePath().isPresent()) {
            FilePreconditions.checkFileExistsAndReadable(this.getSdkArchivePath().get());
            FilePreconditions.checkFileHasExtension("ASAR file", this.getSdkArchivePath().get(), ".asar");
        }
    }

    private void executeForSdkBundle() {
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());
             ZipFile sdkBundleZip = new ZipFile(this.getSdkBundlePath().get().toFile());){
            Path modulesPath = tempDir.getPath().resolve("extracted-modules.resm");
            try (ZipFile modulesZip = BundleParser.getModulesZip(sdkBundleZip, modulesPath);){
                SdkBundleValidator sdkBundleValidator = SdkBundleValidator.create();
                sdkBundleValidator.validateModulesFile(modulesZip);
                SdkBundle sdkBundle = SdkBundle.buildFromZip(sdkBundleZip, modulesZip, 0);
                sdkBundleValidator.validate(sdkBundle);
                this.generateAppApks(sdkBundle.getModule(), tempDir);
            }
        }
        catch (ZipException e11) {
            throw CommandExecutionException.builder().withInternalMessage("ASB is not a valid zip file.").withCause(e11).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the SDK bundle.", e12);
        }
    }

    private void executeForSdkArchive() {
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());
             ZipFile asarZip = new ZipFile(this.getSdkArchivePath().get().toFile());){
            Path modulesPath = tempDir.getPath().resolve("extracted-modules.resm");
            try (ZipFile modulesZip = BundleParser.getModulesZip(asarZip, modulesPath);){
                SdkAsarValidator.validateModulesFile(modulesZip);
                SdkAsar sdkAsar = SdkAsar.buildFromZip(asarZip, modulesZip, modulesPath);
                this.generateAppApks(sdkAsar.getModule(), tempDir);
            }
        }
        catch (ZipException e11) {
            throw CommandExecutionException.builder().withInternalMessage("ASAR is not a valid zip file.").withCause(e11).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the SDK archive.", e12);
        }
    }

    private void generateAppApks(BundleModule sdkModule, TempDirectory tempDirectory) {
        BundleModule convertedAppModule = new SdkModuleToAppBundleModuleConverter(sdkModule, this.getInheritedAppProperties()).convert();
        DaggerBuildSdkApksForAppManagerComponent.builder().setBuildSdkApksForAppCommand(this).setModule(convertedAppModule).setTempDirectory(tempDirectory).build().create().execute();
    }

    private static RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp parseInheritedAppProperties(Path propertiesInheritedFromAppFile) {
        RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp sdkSplitPropertiesInheritedFromApp;
        block8: {
            FilePreconditions.checkFileExistsAndReadable(propertiesInheritedFromAppFile);
            FilePreconditions.checkFileHasExtension("JSON file containing properties inherited from the app", propertiesInheritedFromAppFile, ".json");
            BufferedReader reader = BufferedIo.reader(propertiesInheritedFromAppFile);
            try {
                RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp.Builder builder = RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp.newBuilder();
                JsonFormat.parser().merge(reader, (Message.Builder)builder);
                sdkSplitPropertiesInheritedFromApp = builder.build();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(String.format("Error while reading the file '%s'.", propertiesInheritedFromAppFile), e11);
                }
            }
            ((Reader)reader).close();
        }
        return sdkSplitPropertiesInheritedFromApp;
    }

    private static void populateSigningConfigurationFromFlags(Builder buildSdkApksForAppCommand, ParsedFlags flags, PrintStream out, SystemEnvironmentProvider provider) {
        Optional<Path> keystorePath = KEYSTORE_FLAG.getValue(flags);
        Optional<String> keyAlias = KEY_ALIAS_FLAG.getValue(flags);
        Optional<Password> keystorePassword = KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<Password> keyPassword = KEY_PASSWORD_FLAG.getValue(flags);
        if (keystorePath.isPresent() && keyAlias.isPresent()) {
            SignerConfig signerConfig = SignerConfig.extractFromKeystore(keystorePath.get(), keyAlias.get(), keystorePassword, keyPassword);
            SigningConfiguration.Builder builder = SigningConfiguration.builder().setSignerConfig(signerConfig);
            buildSdkApksForAppCommand.setSigningConfiguration(builder.build());
        } else {
            if (keystorePath.isPresent() && !keyAlias.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --ks-key-alias is required when --ks is set.").build();
            }
            if (!keystorePath.isPresent() && keyAlias.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Flag --ks is required when --ks-key-alias is set.").build();
            }
            Optional<SigningConfiguration> debugConfig = DebugKeystoreUtils.getDebugSigningConfiguration(provider);
            if (debugConfig.isPresent()) {
                out.printf("INFO: The APKs will be signed with the debug keystore found at '%s'.%n", DebugKeystoreUtils.DEBUG_KEYSTORE_CACHE.getUnchecked(provider).get());
                buildSdkApksForAppCommand.setSigningConfiguration(debugConfig.get());
            } else {
                out.println("WARNING: The APKs won't be signed and thus not installable unless you also pass a keystore via the flag --ks. See the command help for more information.");
            }
        }
    }

    private static ListeningExecutorService createInternalExecutorService(int maxThreads) {
        Preconditions.checkArgument(maxThreads >= 0, "The maxThreads must be positive, got %s.", maxThreads);
        return MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(maxThreads));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSdkBundlePath(Path var1);

        public abstract Builder setSdkArchivePath(Path var1);

        abstract Builder setInheritedAppProperties(RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp var1);

        public Builder setInheritedAppProperties(Path inheritedAppProperties) {
            return this.setInheritedAppProperties(BuildSdkApksForAppCommand.parseInheritedAppProperties(inheritedAppProperties));
        }

        public abstract Builder setOutputFile(Path var1);

        public abstract Builder setAapt2Command(Aapt2Command var1);

        public abstract Builder setSigningConfiguration(SigningConfiguration var1);

        @CanIgnoreReturnValue
        public Builder setExecutorService(ListeningExecutorService executorService) {
            this.setExecutorServiceInternal(executorService);
            this.setExecutorServiceCreatedByBundleTool(false);
            return this;
        }

        abstract Builder setExecutorServiceInternal(ListeningExecutorService var1);

        abstract Optional<ListeningExecutorService> getExecutorServiceInternal();

        abstract Builder setExecutorServiceCreatedByBundleTool(boolean var1);

        public abstract BuildSdkApksForAppCommand autoBuild();

        public BuildSdkApksForAppCommand build() {
            if (!this.getExecutorServiceInternal().isPresent()) {
                this.setExecutorServiceInternal(BuildSdkApksForAppCommand.createInternalExecutorService(4));
                this.setExecutorServiceCreatedByBundleTool(true);
            }
            BuildSdkApksForAppCommand command = this.autoBuild();
            Preconditions.checkState(command.getSdkBundlePath().isPresent() ^ command.getSdkArchivePath().isPresent(), "One and only one of SdkBundlePath and SdkArchivePath should be set.");
            return command;
        }
    }
}

