/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.util.Comparator;
import javax.annotation.Nullable;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ZipPath
implements Comparable<ZipPath> {
    private static final String SEPARATOR = "/";
    private static final Splitter SPLITTER = Splitter.on("/").omitEmptyStrings();
    private static final Joiner JOINER = Joiner.on("/");
    private static final ImmutableSet<String> FORBIDDEN_NAMES = ImmutableSet.of("", ".", "..");
    public static final ZipPath ROOT = ZipPath.create("");

    ZipPath() {
    }

    public abstract ImmutableList<String> getNames();

    public static ZipPath create(String path) {
        Preconditions.checkNotNull(path, "Path cannot be null.");
        return ZipPath.create(ImmutableList.copyOf(SPLITTER.splitToList(path)));
    }

    public static ZipPath create(ImmutableList<String> names) {
        names.forEach(name -> {
            Preconditions.checkArgument(!name.contains(SEPARATOR), "Name '%s' contains a forward slash and cannot be used in a path.", name);
            Preconditions.checkArgument(!FORBIDDEN_NAMES.contains(name), "Name '%s' is not supported inside path.", name);
        });
        return new AutoValue_ZipPath(names);
    }

    @CheckReturnValue
    public ZipPath resolve(ZipPath p11) {
        Preconditions.checkNotNull(p11, "Path cannot be null.");
        return ZipPath.create((ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getNames())).addAll(p11.getNames())).build());
    }

    @CheckReturnValue
    public ZipPath resolve(String path) {
        return this.resolve(ZipPath.create(path));
    }

    @CheckReturnValue
    public ZipPath resolveSibling(ZipPath path) {
        Preconditions.checkNotNull(path, "Path cannot be null.");
        Preconditions.checkState(!this.getNames().isEmpty(), "Root has not sibling.");
        return this.getParent().resolve(path);
    }

    @CheckReturnValue
    public ZipPath resolveSibling(String path) {
        return this.resolveSibling(ZipPath.create(path));
    }

    @CheckReturnValue
    public ZipPath subpath(int from, int to2) {
        Preconditions.checkArgument(from >= 0 && from < this.getNames().size());
        Preconditions.checkArgument(to2 >= 0 && to2 <= this.getNames().size());
        Preconditions.checkArgument(from < to2);
        return ZipPath.create((ImmutableList<String>)this.getNames().subList(from, to2));
    }

    @Nullable
    @CheckReturnValue
    public ZipPath getParent() {
        if (this.getNames().isEmpty()) {
            return null;
        }
        return ZipPath.create((ImmutableList<String>)this.getNames().subList(0, this.getNames().size() - 1));
    }

    public int getNameCount() {
        return this.getNames().size();
    }

    public ZipPath getRoot() {
        return ROOT;
    }

    public ZipPath getName(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.getNames().size());
        return ZipPath.create((String)this.getNames().get(index));
    }

    public boolean startsWith(ZipPath p11) {
        if (p11.getNameCount() > this.getNameCount()) {
            return false;
        }
        ImmutableList<String> names = this.getNames();
        ImmutableList<String> otherNames = p11.getNames();
        for (int i11 = 0; i11 < p11.getNameCount(); ++i11) {
            if (((String)otherNames.get(i11)).equals(names.get(i11))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String p11) {
        return this.startsWith(ZipPath.create(p11));
    }

    public boolean endsWith(ZipPath p11) {
        if (p11.getNameCount() > this.getNameCount()) {
            return false;
        }
        ImmutableList<String> names = this.getNames();
        ImmutableList<String> otherNames = p11.getNames();
        for (int i11 = 0; i11 < p11.getNameCount(); ++i11) {
            if (((String)otherNames.get(otherNames.size() - i11 - 1)).equals(names.get(names.size() - i11 - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String p11) {
        return this.endsWith(ZipPath.create(p11));
    }

    @Override
    public final int compareTo(ZipPath other) {
        return Comparators.lexicographical(Comparator.naturalOrder()).compare(this.getNames(), other.getNames());
    }

    public String toString() {
        return JOINER.join(this.getNames());
    }

    public ZipPath getFileName() {
        Preconditions.checkArgument(this.getNameCount() > 0, "Root does not have a file name.");
        return this.getName(this.getNameCount() - 1);
    }
}

