/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Ascii {
    public static final byte NUL = 0;
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte HT = 9;
    public static final byte LF = 10;
    public static final byte NL = 10;
    public static final byte VT = 11;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte SO = 14;
    public static final byte SI = 15;
    public static final byte DLE = 16;
    public static final byte DC1 = 17;
    public static final byte XON = 17;
    public static final byte DC2 = 18;
    public static final byte DC3 = 19;
    public static final byte XOFF = 19;
    public static final byte DC4 = 20;
    public static final byte NAK = 21;
    public static final byte SYN = 22;
    public static final byte ETB = 23;
    public static final byte CAN = 24;
    public static final byte EM = 25;
    public static final byte SUB = 26;
    public static final byte ESC = 27;
    public static final byte FS = 28;
    public static final byte GS = 29;
    public static final byte RS = 30;
    public static final byte US = 31;
    public static final byte SP = 32;
    public static final byte SPACE = 32;
    public static final byte DEL = 127;
    public static final char MIN = '\u0000';
    public static final char MAX = '\u007f';
    private static final char CASE_MASK = ' ';

    private Ascii() {
    }

    public static String toLowerCase(String string) {
        int length = string.length();
        for (int i11 = 0; i11 < length; ++i11) {
            if (!Ascii.isUpperCase(string.charAt(i11))) continue;
            char[] chars = string.toCharArray();
            while (i11 < length) {
                char c11 = chars[i11];
                if (Ascii.isUpperCase(c11)) {
                    chars[i11] = (char)(c11 ^ 0x20);
                }
                ++i11;
            }
            return String.valueOf(chars);
        }
        return string;
    }

    public static String toLowerCase(CharSequence chars) {
        if (chars instanceof String) {
            return Ascii.toLowerCase((String)chars);
        }
        char[] newChars = new char[chars.length()];
        for (int i11 = 0; i11 < newChars.length; ++i11) {
            newChars[i11] = Ascii.toLowerCase(chars.charAt(i11));
        }
        return String.valueOf(newChars);
    }

    public static char toLowerCase(char c11) {
        return Ascii.isUpperCase(c11) ? (char)(c11 ^ 0x20) : c11;
    }

    public static String toUpperCase(String string) {
        int length = string.length();
        for (int i11 = 0; i11 < length; ++i11) {
            if (!Ascii.isLowerCase(string.charAt(i11))) continue;
            char[] chars = string.toCharArray();
            while (i11 < length) {
                char c11 = chars[i11];
                if (Ascii.isLowerCase(c11)) {
                    chars[i11] = (char)(c11 ^ 0x20);
                }
                ++i11;
            }
            return String.valueOf(chars);
        }
        return string;
    }

    public static String toUpperCase(CharSequence chars) {
        if (chars instanceof String) {
            return Ascii.toUpperCase((String)chars);
        }
        char[] newChars = new char[chars.length()];
        for (int i11 = 0; i11 < newChars.length; ++i11) {
            newChars[i11] = Ascii.toUpperCase(chars.charAt(i11));
        }
        return String.valueOf(newChars);
    }

    public static char toUpperCase(char c11) {
        return Ascii.isLowerCase(c11) ? (char)(c11 ^ 0x20) : c11;
    }

    public static boolean isLowerCase(char c11) {
        return c11 >= 'a' && c11 <= 'z';
    }

    public static boolean isUpperCase(char c11) {
        return c11 >= 'A' && c11 <= 'Z';
    }

    public static String truncate(CharSequence seq, int maxLength, String truncationIndicator) {
        Preconditions.checkNotNull(seq);
        int truncationLength = maxLength - truncationIndicator.length();
        Preconditions.checkArgument(truncationLength >= 0, "maxLength (%s) must be >= length of the truncation indicator (%s)", maxLength, truncationIndicator.length());
        if (seq.length() <= maxLength) {
            String string = seq.toString();
            if (string.length() <= maxLength) {
                return string;
            }
            seq = string;
        }
        return new StringBuilder(maxLength).append(seq, 0, truncationLength).append(truncationIndicator).toString();
    }

    public static boolean equalsIgnoreCase(CharSequence s12, CharSequence s22) {
        int length = s12.length();
        if (s12 == s22) {
            return true;
        }
        if (length != s22.length()) {
            return false;
        }
        for (int i11 = 0; i11 < length; ++i11) {
            int alphaIndex;
            char c22;
            char c12 = s12.charAt(i11);
            if (c12 == (c22 = s22.charAt(i11)) || (alphaIndex = Ascii.getAlphaIndex(c12)) < 26 && alphaIndex == Ascii.getAlphaIndex(c22)) continue;
            return false;
        }
        return true;
    }

    private static int getAlphaIndex(char c11) {
        return (char)((c11 | 0x20) - 97);
    }
}

