/* Created RJudd */
/* SPAWARSYSCEN D881 */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* new version done August 2000 */
/* $Id: vsip_mprod_d.c,v 2.0 2003/02/22 15:18:58 judd Exp $ */

#include<vsip.h>
#include<vsip_mviewattributes_d.h>

void (vsip_mprod_d)(
    const vsip_mview_d* a,
    const vsip_mview_d* b,
    const vsip_mview_d* r)
{
    vsip_scalar_d *ap = (a->block->array) + a->offset * a->block->rstride,
                  *bp = (b->block->array) + b->offset * b->block->rstride,
                  *rp = (r->block->array) + r->offset * r->block->rstride;
    vsip_scalar_d *ap0 = ap,
                  *bp0 = bp,
                  *rp0 = rp;
    vsip_scalar_d *bp1 = bp;
    if((a->row_stride == 1) && ((vsip_stride)a->row_length == a->col_stride) &&
       (b->col_stride == 1) && ((vsip_stride)b->col_length == b->row_stride) &&
       (r->row_stride == 1) && (r->col_stride == (vsip_stride)r->row_length) &&
       (a->block->rstride == 1) && (b->block->rstride == 1) && (r->block->rstride == 1)){
           vsip_scalar_d temp;
           vsip_length a_c_l = a->col_length;
           vsip_length a_r_l = a->row_length;
           vsip_length r_r_l = r->row_length;
           while(a_c_l-- > 0){
              while(r_r_l-- > 0){
                 ap = ap0; temp = 0;
                 while(a_r_l-- > 0){ 
                   temp += *ap++ * *bp++; 
              } 
              *rp++ = temp; a_r_l = a->row_length; 
           }
           ap0 = ap;
           bp = bp0;
           r_r_l = r->row_length;
        }
    } else if((a->row_stride == 1) && ((vsip_stride)a->row_length == a->col_stride) &&
       (b->col_stride == 1) && ((vsip_stride)b->col_length == b->row_stride) &&
       (r->row_stride == 1) && (r->col_stride == (vsip_stride)r->row_length)){
           vsip_scalar_d temp;
           vsip_stride a_st = a->block->rstride,
                       b_st = b->block->rstride,
                       r_st = r->block->rstride;
           vsip_length a_c_l = a->col_length;
           vsip_length a_r_l = a->row_length;
           vsip_length r_r_l = r->row_length;
           while(a_c_l-- > 0){
              while(r_r_l-- > 0){
                 ap = ap0; temp = 0;
                 while(a_r_l-- > 0){ 
                   temp += *ap * *bp; 
                    ap += a_st; bp += b_st;
              } 
              *rp = temp;
              rp += r_st; a_r_l = a->row_length; 
           }
           ap0 = ap;
           bp = bp0;
           r_r_l = r->row_length;
        }
    } else {
        vsip_scalar_d temp;
        vsip_stride a_st_r = a->row_stride * a->block->rstride,
                   a_st_c = a->col_stride * a->block->rstride,
                   b_st_r = b->row_stride * b->block->rstride,
                   b_st_c = b->col_stride * b->block->rstride,
                   r_st_r = r->row_stride * r->block->rstride,
                   r_st_c = r->col_stride * r->block->rstride;
        vsip_length a_c_l  = a->col_length;
        vsip_length a_r_l  = a->row_length;
        vsip_length r_r_l = r->row_length;
        while(a_c_l-- > 0){
           while(r_r_l-- > 0){
              temp = 0;
              while(a_r_l-- > 0){
                 temp += *ap * *bp;
                  ap += a_st_r; bp += b_st_c;
              }
              *rp = temp;
              rp += r_st_r;
              ap = ap0;
              bp0 += b_st_r; bp = bp0;
              a_r_l = a->row_length;
           }
           ap0 += a_st_c; ap = ap0;
           bp0 = bp1; bp = bp0;
           rp0 += r_st_c; rp = rp0;
           r_r_l = r->row_length;
        }
    } 
}
