// Copyright (c) Glyn Matthews 2012-2016.
// Copyright 2012 Dean Michael Berris <dberris@google.com>
// Copyright 2012 Google, Inc.
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef NETWORK_URI_HPP
#define NETWORK_URI_HPP

/**
 * \defgroup uri URI
 *
 * This module contains a class encapsulating a URI, a URI builder and
 * percent encoding and decoding functions.
 *
 * \defgroup optional Optional
 *
 * This module contains a utility to represent optional values.
 *
 * \defgroup string String
 *
 * This module contains a class for a non-owning reference to a string.
 *
 * \namespace network
 *
 * The \c network namespace contains all the classes and functions for
 * the URI in this library.
 *
 * \file
 * \brief Contains the uri, uri_builder classes and functions
 *        for percent encoding and decoding.
 */

#include <network/uri/uri.hpp>
#include <network/uri/uri_io.hpp>

#endif  // NETWORK_URI_HPP
