/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as m,html as a,nothing as u}from"lit";import{property as p,state as h,customElement as v}from"lit/decorators.js";import b from"@typo3/core/ajax/ajax-request.js";import"@typo3/backend/element/icon-element.js";var s=function(c,e,t,n){var l=arguments.length,i=l<3?e:n===null?n=Object.getOwnPropertyDescriptor(e,t):n,r;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")i=Reflect.decorate(c,e,t,n);else for(var d=c.length-1;d>=0;d--)(r=c[d])&&(i=(l<3?r(i):l>3?r(e,t,i):r(e,t))||i);return l>3&&i&&Object.defineProperty(e,t,i),i};let o=class extends m{constructor(){super(...arguments),this.activeColorScheme=null,this.colorSchemes=null,this.advancedOptionsExpanded=!1,this.autoDetect=null,this.mql=null,this.mediaQueryListener=e=>this.autoDetect=e.matches?"dark":"light"}connectedCallback(){super.connectedCallback(),this.mql=window.matchMedia("(prefers-color-scheme: dark)"),this.mediaQueryListener(this.mql),this.mql.addEventListener("change",this.mediaQueryListener)}disconnectedCallback(){super.disconnectedCallback(),this.mql.removeEventListener("change",this.mediaQueryListener),this.mql=null}createRenderRoot(){return this}getRealColorScheme(){return this.activeColorScheme==="auto"?this.autoDetect??"light":this.activeColorScheme??"light"}render(){return a`<div class=btn-group><button type=button class="btn btn-default" title=${this.label} @click=${e=>this.toggle(e)}><typo3-backend-icon identifier=${this.getIcon(this.activeColorScheme??"auto")} size=small></typo3-backend-icon>${this.getLabel(this.getRealColorScheme())}<typo3-backend-icon identifier=actions-exchange size=small style=margin-left:auto></typo3-backend-icon></button> <button type=button class="btn btn-default ${this.advancedOptionsExpanded?"active":""}" aria-haspopup=true aria-expanded=${this.advancedOptionsExpanded?"true":"false"} @click=${e=>{e.stopPropagation(),this.advancedOptionsExpanded=!this.advancedOptionsExpanded}}><span class=visually-hidden>Show more options</span><typo3-backend-icon identifier=${this.advancedOptionsExpanded?"actions-chevron-up":"actions-chevron-down"} size=small></typo3-backend-icon></button></div>${this.advancedOptionsExpanded===!1?u:a`<ul class=dropdown-list>${this.colorSchemes.map(e=>this.renderItem(e))}</ul>`}`}getIcon(e){return this.colorSchemes.find(t=>t.value===e)?.icon??"auto"}getLabel(e){return this.colorSchemes.find(t=>t.value===e)?.label??""}renderItem(e){return a`<li><button class=dropdown-item @click=${t=>this.handleClick(t,e.value)} aria-current=${this.activeColorScheme===e.value?"true":"false"}><span class=dropdown-item-columns> <span class="dropdown-item-column dropdown-item-column-icon" aria-hidden=true><typo3-backend-icon identifier=${e.icon} size=small></typo3-backend-icon> </span> <span class="dropdown-item-column dropdown-item-column-title">${e.label} ${e.value==="auto"?a`<span class=dropdown-item-column-title-info>${this.getLabel(this.autoDetect)}</span>`:""} </span> ${this.activeColorScheme===e.value?a`<span class=text-primary> <typo3-backend-icon identifier=actions-dot size=small></typo3-backend-icon> </span>`:a`<typo3-backend-icon identifier=empty-empty size=small></typo3-backend-icon>`} </span></button></li>`}async toggle(e){e.preventDefault(),e.stopPropagation();let n=this.getRealColorScheme()==="dark"?"light":"dark";n===this.autoDetect&&(n="auto"),this.triggerSchemeUpdate(n),await this.persistSchemeUpdate(n)}async handleClick(e,t){e.preventDefault(),e.stopPropagation(),this.triggerSchemeUpdate(t),await this.persistSchemeUpdate(t),this.advancedOptionsExpanded=!1}async persistSchemeUpdate(e){const t=new URL(TYPO3.settings.ajaxUrls.color_scheme_update,window.location.origin);return await new b(t).post({colorScheme:e})}triggerSchemeUpdate(e){document.dispatchEvent(new CustomEvent("typo3:color-scheme:update",{detail:{colorScheme:e}}))}};s([p({type:String})],o.prototype,"activeColorScheme",void 0),s([p({type:Array})],o.prototype,"colorSchemes",void 0),s([p({type:String})],o.prototype,"label",void 0),s([h()],o.prototype,"advancedOptionsExpanded",void 0),s([h()],o.prototype,"autoDetect",void 0),o=s([v("typo3-backend-color-scheme-switch")],o);export{o as ColorSchemeSwitchElement};
