/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as r,customElement as b}from"lit/decorators.js";import{LitElement as v,html as p,nothing as h}from"lit";import{classMap as y}from"lit/directives/class-map.js";import{SeverityEnum as n}from"@typo3/backend/enum/severity.js";import g from"@typo3/backend/severity.js";import"@typo3/backend/element/icon-element.js";import{lll as u}from"@typo3/core/lit-helper.js";var s=function(a,t,o,l){var c=arguments.length,i=c<3?t:l===null?l=Object.getOwnPropertyDescriptor(t,o):l,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")i=Reflect.decorate(a,t,o,l);else for(var m=a.length-1;m>=0;m--)(d=a[m])&&(i=(c<3?d(i):c>3?d(t,o,i):d(t,o))||i);return c>3&&i&&Object.defineProperty(t,o,i),i},f;let e=f=class extends v{constructor(){super(...arguments),this.severity=n.info,this.dismissible=!1,this.visible=!0,this.heading=null,this.message=null,this.showIcon=!1,this.randomSuffix=Math.random().toString(36).substring(7)}static getIconIdentifier(t){return{[n.notice]:"actions-lightbulb",[n.ok]:"actions-check",[n.warning]:"actions-exclamation",[n.error]:"actions-close",[n.info]:"actions-info"}[t]||"actions-info"}createRenderRoot(){return this}render(){return p`<div id=alert-${this.randomSuffix} class=${y(this.getClasses())} role=alert aria-labelledby=alert-title-${this.randomSuffix} aria-describedby=alert-message-${this.randomSuffix} @closed.bs.alert=${this.remove}><div class=alert-inner>${this.showIcon?p`<div class=alert-icon><span class=icon-emphasized> <typo3-backend-icon identifier=${f.getIconIdentifier(this.severity)} size=small></typo3-backend-icon> </span></div>`:h}<div class=alert-content>${this.heading?p`<h4 class=alert-title id=alert-title-${this.randomSuffix}>${this.heading}</h4>`:h}<p class=alert-body id=alert-message-${this.randomSuffix}>${this.message}</p></div></div>${this.dismissible?this.renderDismissButton():h}</div>`}getClasses(){return{alert:!0,["alert-"+g.getCssClass(this.severity)]:!0,"alert-dismissible":this.dismissible,fade:!0,show:this.visible,hidden:!this.visible}}renderDismissButton(){return p`<button type=button class=close data-bs-dismiss=alert aria-label=${u("button.close")||"Close"}><span aria-hidden=true><typo3-backend-icon identifier=actions-close size=small></typo3-backend-icon></span> <span class=visually-hidden>${u("button.close")||"Close"}</span></button>`}};s([r({type:Number})],e.prototype,"severity",void 0),s([r({type:Boolean})],e.prototype,"dismissible",void 0),s([r({type:Boolean})],e.prototype,"visible",void 0),s([r({type:String})],e.prototype,"heading",void 0),s([r({type:String})],e.prototype,"message",void 0),s([r({type:Boolean,attribute:"show-icon"})],e.prototype,"showIcon",void 0),e=f=s([b("typo3-backend-alert")],e);export{e as AlertElement};
