# Usenet Reborn
**The TUI client for Usenet enthusiasts**

**Author:** Chris F.N. (aka ReK2)  
**License:** GPLv3

---

## Overview

**Usenet Reborn** is a terminal‑based NNTP client written in Rust, featuring:

- **Browse Newsgroups**: Navigate your subscriptions, view unread articles.
- **Read Articles**: Fetch and display article bodies in a scrollable UI.
- **Compose & Reply**: Create new posts or reply to existing ones using your configured `$EDITOR`.
- **Manage Read Flags**: Mark articles as read/unread; state persisted in SQLite.
- **Signature Support**: Automatically append a signature from `$SIGNATURE_FILE` or `~/.signature`.
- **Open links:** Get a list of GOPHER,GEMINI,HTTPS,FTP,ETC links to send to `xdg-open`.

The application uses [`ratatui`](https://ratatui.rs/) + [`crossterm`](https://docs.rs/crossterm/latest/crossterm/) for the UI, and [`rek2_nntp`](https://crates.io/crates/rek2_nntp) for NNTP interactions.

![Usenet Reborn in action](assets/usenet_reborn.png)
## TODO
- See the full `TODO` List [Here](https://sr.ht/~rek2/Usenet_Reborn/trackers)
- [X] Add threaded view capability (display conversations as threads)
- [X] Parse URLs in articles and allow opening them in the default browser
- [ ] Improve UI aesthetics and overall look-and-feel
- [ ] Add reload key, or auto reload option
- [X] Create Project mailing list and tickets for patches and todo list
- [X] Capable of reading configs from standard OS home directories path GNU/Linux and MacOS

---

## Installation

1. **Clone the repo**
   ```bash
   git clone https://git.sr.ht/~rek2/usenet_reborn
   cd usenet_reborn
   ```
2. **Build**
   ```bash
   cargo build --release
   ```
3. **Configuration**
   - Create `config.toml`:
   - you can use the example file inside ./configs folder
     ```toml
     [usenet.server]
     username = "your_newsserver_username"
     password = ""            # leave blank to use `pass` or compatible like `gopass`
     server   = "news.example.com"

     [headers]
     from_header  = "Your Name"
     email_header = "you@example.com"

     [display]
     threaded_view = true
     ```
   - Create a `subscriptions` file listing one newsgroup per line:
   - you can use the example file inside ./configs folder
     ```text
     alt.comp.lang.rust
     comp.sys.ibm.pc.hardware
     ```
   - (Optional) Add a signature file:
     - Set `$SIGNATURE_FILE` to point to your sig, or place `~/.signature`.
     - Example `~/.signature`:
       ```text
       Chris F.N. (ReK2)
       https://rek2.hispagatos.org
       gemini://rek2.hispagatos.org
       ```

## Arch Linux Package

You can also install via the Arch User Repository (AUR):
```
paru -S usenet_reborn-git
```

---

## Usage

Before runing the client:
 - `EDITOR` and `SIGNATURE_FILE` you should add and export these variables on your .bashrc or equivalent. 
 
```bash
EDITOR=vim SIGNATURE_FILE="$HOME/.signature" ./target/release/usenet_reborn
```


 - you can copy the resulting binary to somewhere in your $PATH like ~/bin/usenet_reborn or /usr/local/bin/usenet_reborn


## Configuration & Paths

Usenet Reborn will look for its files in the standard OS locations first; if not found, it falls back to wherever you run the binary.

- **Config file** (`config.toml`):
  - Linux: `~/.config/usenet_reborn/config.toml`
  - macOS: `~/Library/Application Support/ReK2/usenet_reborn/config.toml`
  - or in the current directory (`./config.toml`)

- **Subscriptions** (`subscriptions`):
  - Linux: `~/.config/usenet_reborn/subscriptions`
  - macOS: `~/Library/Application Support/ReK2/usenet_reborn/subscriptions`
  - or in the current directory (`./subscriptions`)

- **Cache database** (`cache.sqlite3`):
  - Linux: `~/.cache/usenet_reborn/cache.sqlite3`
  - macOS: `~/Library/Caches/ReK2/usenet_reborn/cache.sqlite3`

If any required file is missing, Usenet Reborn will exit with an error telling you exactly where to place it.


### Keybindings

| View           | Keys                         | Action                                              |
|----------------|-------------------------------|-----------------------------------------------------|
| **Global**     | Ctrl+h / Ctrl+l                | Switch between Newsgroups ↔ Articles views          |
|                | Ctrl+u                         | Update articles from server                        | 
| **Groups**     | j / k                          | Move selection up/down                             |
|                | Enter                          | Load unread articles for selected newsgroup        |
|                | q                              | Quit                                                |
| **Articles**   | j / k                          | Move selection up/down                             |
|                | Enter                          | Display article body                               |
|                | Space                          | Toggle read/unread flag                            |
|                | Ctrl+r                         | Mark all messages in selected newsgroup as read    |
|                | n                              | Compose new post (popup for newsgroups & subject)   |
|                | r                              | Reply to selected article                          |
|                | q                              | Clear status / remain in Articles view             |
|                | Esc                            | Back to Newsgroups view                            |
| **Article**    | j / k                          | Scroll body up/down                                |
|                | o                              | Open links in external browser (`xdg-open`)        |
|                | r                              | Reply to this article                              |
|                | q / Esc                        | Back to Articles view                              |
| **Article Insert Mode** | i                | Enter **Insert mode** (move cursor freely)          |
|                | v                              | Enter **Visual mode** (start text selection)        |
|                | h / j / k / l | Move cursor left / down / up / right               |
|                | y              | Yank (copy) selected text to clipboard             |
|                | Esc (in Insert/Visual mode)    | Exit mode                                           |

---

## Compose/Reply Popup

When composing a **new post** (`n`) or **replying** (`r`) inside **Articles view**:

| Action | Keys              |
|--------|-------------------|
| Switch field | Tab          |
| Confirm      | Enter        |
| Cancel       | Esc          |

You'll then be dropped into your configured `$EDITOR` to write the body of the post.

---

## Configuration & Environment

- **`config.toml`**: Usenet server and headers settings.
- **`subscriptions`**: One newsgroup per line.
- **Environment Variables**:
  - `EDITOR`: Which editor to use (default: `nano`).
  - `SIGNATURE_FILE`: Path to signature file (defaults to `~/.signature`).
- **`xdg-open`:** to open links on default external programs.
---

## Data Persistence

- Uses SQLite (`cache.sqlite3`) to store:
  - **Last seen article ID** per newsgroup
  - **Article cache** (subjects, senders, dates, read flags)

---

## Dependencies

- **ratatui**: Terminal UI toolkit
- **crossterm**: Cross‑platform terminal manipulation
- [**rek2_nntp**](https://crates.io/crates/rek2_nntp): NNTP client library
- **rusqlite**: SQLite backend
- **tokio**: Async runtime
- **tempfile**: Temporary file management
- **chrono**: Date parsing/formatting

---
## Patches and Suggestions
- First please read the email and todo [etiquette](https://man.sr.ht/lists.sr.ht/etiquette.md)
- Using [Git Send-Email](https://man.sr.ht/git.sr.ht/send-email.md) for sending patches, [Interactive Tutorial](https://git-send-email.io/)
- Subscribe to `mailing` list for patches and discussion sending email to `~rek2/Usenet_Reborn+subscribe@lists.sr.ht` keep the case as `Usenet_Reborn`.
- Send patches to `~rek2/Usenet_Reborn@lists.sr.ht` **after** you subscribe! keep the case as `Usenet_Reborn`. 

## To report issues 
- Please [Open a ticket](https://todo.sr.ht/~rek2/Usenet_Reborn_Issues)

---
## License

This project is licensed under the **GPLv3**. See [LICENSE](LICENSE) for details.

---

*Happy Usenet-ing!*

