/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <assert.h>
#include <vsync/atomic.h>
/*****************************************************************************
 * UnitTest: vatomicptr_read
 *****************************************************************************/
static inline void
ut_atomic_ptr_read(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_read_acq
 *****************************************************************************/
static inline void
ut_atomic_ptr_read_acq(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read_acq(&obj);
    assert(val == NULL);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_read_rlx
 *****************************************************************************/
static inline void
ut_atomic_ptr_read_rlx(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read_rlx(&obj);
    assert(val == NULL);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_init
 *****************************************************************************/
static inline void
ut_atomic_ptr_init(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    vatomicptr_init(&obj, (void *)VUINTPTR_MAX);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_write
 *****************************************************************************/
static inline void
ut_atomic_ptr_write(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    vatomicptr_write(&obj, (void *)VUINTPTR_MAX);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_write_rel
 *****************************************************************************/
static inline void
ut_atomic_ptr_write_rel(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    vatomicptr_write_rel(&obj, (void *)VUINTPTR_MAX);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_write_rlx
 *****************************************************************************/
static inline void
ut_atomic_ptr_write_rlx(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    vatomicptr_write_rlx(&obj, (void *)VUINTPTR_MAX);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomicptr_xchg
 *****************************************************************************/
static inline void
ut_atomic_ptr_xchg(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    void *old = vatomicptr_xchg(&obj, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_xchg_acq
 *****************************************************************************/
static inline void
ut_atomic_ptr_xchg_acq(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    void *old = vatomicptr_xchg_acq(&obj, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_xchg_rel
 *****************************************************************************/
static inline void
ut_atomic_ptr_xchg_rel(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    void *old = vatomicptr_xchg_rel(&obj, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_xchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_ptr_xchg_rlx(void)
{
    vatomicptr_t obj = {NULL};
    void *val        = vatomicptr_read(&obj);
    assert(val == NULL);
    void *old = vatomicptr_xchg_rlx(&obj, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_cmpxchg
 *****************************************************************************/
static inline void
ut_atomic_ptr_cmpxchg(void)
{
    vatomicptr_t obj = {NULL};
    /* test failure */
    void *old = vatomicptr_cmpxchg(&obj, (void *)VUINTPTR_MAX, NULL);
    assert(old == NULL);
    void *val = vatomicptr_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicptr_cmpxchg(&obj, NULL, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_cmpxchg_acq
 *****************************************************************************/
static inline void
ut_atomic_ptr_cmpxchg_acq(void)
{
    vatomicptr_t obj = {NULL};
    /* test failure */
    void *old = vatomicptr_cmpxchg_acq(&obj, (void *)VUINTPTR_MAX, NULL);
    assert(old == NULL);
    void *val = vatomicptr_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicptr_cmpxchg_acq(&obj, NULL, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_cmpxchg_rel
 *****************************************************************************/
static inline void
ut_atomic_ptr_cmpxchg_rel(void)
{
    vatomicptr_t obj = {NULL};
    /* test failure */
    void *old = vatomicptr_cmpxchg_rel(&obj, (void *)VUINTPTR_MAX, NULL);
    assert(old == NULL);
    void *val = vatomicptr_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicptr_cmpxchg_rel(&obj, NULL, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomicptr_cmpxchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_ptr_cmpxchg_rlx(void)
{
    vatomicptr_t obj = {NULL};
    /* test failure */
    void *old = vatomicptr_cmpxchg_rlx(&obj, (void *)VUINTPTR_MAX, NULL);
    assert(old == NULL);
    void *val = vatomicptr_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomicptr_cmpxchg_rlx(&obj, NULL, (void *)VUINTPTR_MAX);
    assert(old == NULL);
    val = vatomicptr_read(&obj);
    assert(val == (void *)VUINTPTR_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    ut_atomic_ptr_read();
    ut_atomic_ptr_read_acq();
    ut_atomic_ptr_read_rlx();

    ut_atomic_ptr_init();

    ut_atomic_ptr_write();
    ut_atomic_ptr_write_rel();
    ut_atomic_ptr_write_rlx();

    ut_atomic_ptr_xchg();
    ut_atomic_ptr_xchg_acq();
    ut_atomic_ptr_xchg_rel();
    ut_atomic_ptr_xchg_rlx();

    ut_atomic_ptr_cmpxchg();
    ut_atomic_ptr_cmpxchg_acq();
    ut_atomic_ptr_cmpxchg_rel();
    ut_atomic_ptr_cmpxchg_rlx();

    return 0;
}
