/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <assert.h>
#include <vsync/atomic.h>
#define BYTE_WIDTH 8U
/*****************************************************************************
 * UnitTest: vatomic16_read
 *****************************************************************************/
static inline void
ut_atomic_u16_read(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_read_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_read_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read_acq(&obj);
    assert(val == (vuint16_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_read_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_read_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read_rlx(&obj);
    assert(val == (vuint16_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_init
 *****************************************************************************/
static inline void
ut_atomic_u16_init(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vatomic16_init(&obj, VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_write
 *****************************************************************************/
static inline void
ut_atomic_u16_write(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vatomic16_write(&obj, VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_write_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_write_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vatomic16_write_rel(&obj, VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_write_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_write_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vatomic16_write_rlx(&obj, VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_xchg
 *****************************************************************************/
static inline void
ut_atomic_u16_xchg(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vuint16_t old = vatomic16_xchg(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_xchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_xchg_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vuint16_t old = vatomic16_xchg_acq(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_xchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_xchg_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vuint16_t old = vatomic16_xchg_rel(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_xchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_xchg_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t val   = vatomic16_read(&obj);
    assert(val == (vuint16_t)1);
    vuint16_t old = vatomic16_xchg_rlx(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_cmpxchg
 *****************************************************************************/
static inline void
ut_atomic_u16_cmpxchg(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    /* test failure */
    vuint16_t old = vatomic16_cmpxchg(&obj, VUINT16_MAX, (vuint16_t)1);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic16_cmpxchg(&obj, (vuint16_t)1, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_cmpxchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_cmpxchg_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    /* test failure */
    vuint16_t old = vatomic16_cmpxchg_acq(&obj, VUINT16_MAX, (vuint16_t)1);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic16_cmpxchg_acq(&obj, (vuint16_t)1, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_cmpxchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_cmpxchg_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    /* test failure */
    vuint16_t old = vatomic16_cmpxchg_rel(&obj, VUINT16_MAX, (vuint16_t)1);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic16_cmpxchg_rel(&obj, (vuint16_t)1, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_cmpxchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_cmpxchg_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    /* test failure */
    vuint16_t old = vatomic16_cmpxchg_rlx(&obj, VUINT16_MAX, (vuint16_t)1);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic16_cmpxchg_rlx(&obj, (vuint16_t)1, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val, old);
}
/* ****************************************************************************
 * UnitTest: vatomic16_add
 * ****************************************************************************/
static inline void
ut_atomic_u16_add(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_add(&obj, v);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_add_rel
 * ****************************************************************************/
static inline void
ut_atomic_u16_add_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_add_rel(&obj, v);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_add_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u16_add_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_add_rlx(&obj, v);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_add
 *****************************************************************************/
static inline void
ut_atomic_u16_get_add(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_add(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_add_get
 *****************************************************************************/
static inline void
ut_atomic_u16_add_get(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_add_get(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_add_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_add_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_add_acq(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_add_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_add_get_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_add_get_acq(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_add_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_add_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_add_rel(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_add_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_add_get_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_add_get_rel(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_add_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_add_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_add_rlx(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_add_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_add_get_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_add_get_rlx(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic16_inc
 * ****************************************************************************/
static inline void
ut_atomic_u16_inc(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_inc(&obj);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_inc_rel
 * ****************************************************************************/
static inline void
ut_atomic_u16_inc_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_inc_rel(&obj);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_inc_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u16_inc_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_inc_rlx(&obj);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_inc
 *****************************************************************************/
static inline void
ut_atomic_u16_get_inc(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_inc(&obj);
        assert(old == ref);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_inc_get
 *****************************************************************************/
static inline void
ut_atomic_u16_inc_get(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref++;
        cur = vatomic16_inc_get(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_inc_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_inc_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_inc_acq(&obj);
        assert(old == ref);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_inc_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_inc_get_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref++;
        cur = vatomic16_inc_get_acq(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_inc_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_inc_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_inc_rel(&obj);
        assert(old == ref);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_inc_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_inc_get_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref++;
        cur = vatomic16_inc_get_rel(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_inc_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_inc_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_inc_rlx(&obj);
        assert(old == ref);
        ref++;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_inc_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_inc_get_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref++;
        cur = vatomic16_inc_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_sub
 * ****************************************************************************/
static inline void
ut_atomic_u16_sub(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_sub(&obj, v);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_sub_rel
 * ****************************************************************************/
static inline void
ut_atomic_u16_sub_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_sub_rel(&obj, v);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_sub_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u16_sub_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_sub_rlx(&obj, v);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_sub
 *****************************************************************************/
static inline void
ut_atomic_u16_get_sub(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_sub(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_sub_get
 *****************************************************************************/
static inline void
ut_atomic_u16_sub_get(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_sub_get(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_sub_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_sub_acq(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_sub_acq(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_sub_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_sub_get_acq(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_sub_get_acq(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_sub_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_sub_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_sub_rel(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_sub_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_sub_get_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_sub_get_rel(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_sub_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_sub_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t old   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_sub_rlx(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_sub_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_sub_get_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;
    vuint16_t cur   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        cur = vatomic16_sub_get_rlx(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic16_dec
 * ****************************************************************************/
static inline void
ut_atomic_u16_dec(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_dec(&obj);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_dec_rel
 * ****************************************************************************/
static inline void
ut_atomic_u16_dec_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_dec_rel(&obj);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic16_dec_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u16_dec_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        vatomic16_dec_rlx(&obj);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_dec
 *****************************************************************************/
static inline void
ut_atomic_u16_get_dec(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t old   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_dec(&obj);
        assert(old == ref);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_dec_get
 *****************************************************************************/
static inline void
ut_atomic_u16_dec_get(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref--;
        cur = vatomic16_dec_get(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_dec_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_dec_acq(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t old   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_dec_acq(&obj);
        assert(old == ref);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_dec_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_dec_get_acq(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref--;
        cur = vatomic16_dec_get_acq(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_dec_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_dec_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t old   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_dec_rel(&obj);
        assert(old == ref);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_dec_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_dec_get_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref--;
        cur = vatomic16_dec_get_rel(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_dec_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_dec_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t old   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        old = vatomic16_get_dec_rlx(&obj);
        assert(old == ref);
        ref--;
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_dec_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_dec_get_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t max   = (vuint16_t)1 + (vuint16_t)10;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t val   = 0;

    for (vuint16_t v = (vuint16_t)1; v <= max; v++) {
        ref--;
        cur = vatomic16_dec_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic16_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_max
 *****************************************************************************/
static inline void
ut_atomic_u16_max(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vatomic16_max(&obj, VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    vatomic16_max(&obj, (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_max_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vatomic16_max_rel(&obj, VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    vatomic16_max_rel(&obj, (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_max_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vatomic16_max_rlx(&obj, VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    vatomic16_max_rlx(&obj, (vuint16_t)1);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_max
 *****************************************************************************/
static inline void
ut_atomic_u16_get_max(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t old = vatomic16_get_max(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    old = vatomic16_get_max(&obj, (vuint16_t)1);
    assert(old == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_max_get
 *****************************************************************************/
static inline void
ut_atomic_u16_max_get(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t cur = vatomic16_max_get(&obj, VUINT16_MAX);
    assert(cur == VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    cur = vatomic16_max_get(&obj, (vuint16_t)1);
    assert(cur == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_max_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_max_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t old = vatomic16_get_max_acq(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    old = vatomic16_get_max_acq(&obj, (vuint16_t)1);
    assert(old == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_max_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_max_get_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t cur = vatomic16_max_get_acq(&obj, VUINT16_MAX);
    assert(cur == VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    cur = vatomic16_max_get_acq(&obj, (vuint16_t)1);
    assert(cur == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_max_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t old = vatomic16_get_max_rel(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    old = vatomic16_get_max_rel(&obj, (vuint16_t)1);
    assert(old == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_max_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_max_get_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t cur = vatomic16_max_get_rel(&obj, VUINT16_MAX);
    assert(cur == VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    cur = vatomic16_max_get_rel(&obj, (vuint16_t)1);
    assert(cur == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_max_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t old = vatomic16_get_max_rlx(&obj, VUINT16_MAX);
    assert(old == (vuint16_t)1);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    old = vatomic16_get_max_rlx(&obj, (vuint16_t)1);
    assert(old == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_max_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_max_get_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};

    /* test write */
    vuint16_t cur = vatomic16_max_get_rlx(&obj, VUINT16_MAX);
    assert(cur == VUINT16_MAX);
    vuint16_t val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    /* test no write */
    cur = vatomic16_max_get_rlx(&obj, (vuint16_t)1);
    assert(cur == VUINT16_MAX);
    val = vatomic16_read(&obj);
    assert(val == VUINT16_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic16_and
 *****************************************************************************/
static inline void
ut_atomic_u16_and(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic16_and(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_and_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic16_and_rel(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_and_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic16_and_rlx(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_and
 *****************************************************************************/
static inline void
ut_atomic_u16_get_and(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic16_get_and(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_and_get
 *****************************************************************************/
static inline void
ut_atomic_u16_and_get(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic16_and_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_and_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_and_acq(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic16_get_and_acq(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_and_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_and_get_acq(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic16_and_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_and_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic16_get_and_rel(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_and_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_and_get_rel(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic16_and_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_and_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic16_get_and_rlx(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_and_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_and_get_rlx(void)
{
    vatomic16_t obj = {VUINT16_MAX};
    vuint16_t mask  = VUINT16_MAX;
    vuint16_t ref   = VUINT16_MAX;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic16_and_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or
 *****************************************************************************/
static inline void
ut_atomic_u16_or(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic16_or(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_or_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic16_or_rel(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_or_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic16_or_rlx(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_or
 *****************************************************************************/
static inline void
ut_atomic_u16_get_or(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic16_get_or(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get
 *****************************************************************************/
static inline void
ut_atomic_u16_or_get(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic16_or_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_or_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_or_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic16_get_or_acq(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_or_get_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic16_or_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_or_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic16_get_or_rel(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_or_get_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic16_or_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_or_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic16_get_or_rlx(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_or_get_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic16_or_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_xor
 *****************************************************************************/
static inline void
ut_atomic_u16_xor(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic16_xor(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_xor_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic16_xor_rel(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_xor_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic16_xor_rlx(&obj, mask);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_xor
 *****************************************************************************/
static inline void
ut_atomic_u16_get_xor(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic16_get_xor(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get
 *****************************************************************************/
static inline void
ut_atomic_u16_xor_get(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic16_xor_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_xor_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_get_xor_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic16_get_xor_acq(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u16_xor_get_acq(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic16_xor_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_get_xor_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic16_get_xor_rel(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u16_xor_get_rel(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic16_xor_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_get_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_get_xor_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0x33;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;
    vuint16_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic16_get_xor_rlx(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic16_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u16_xor_get_rlx(void)
{
    vatomic16_t obj = {(vuint16_t)1};
    vuint16_t mask  = 0xFF;
    vuint16_t ref   = (vuint16_t)1;
    vuint16_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint16_t); i++) {
        mask = (vuint16_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic16_xor_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic16_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    ut_atomic_u16_read();
    ut_atomic_u16_read_acq();
    ut_atomic_u16_read_rlx();

    ut_atomic_u16_init();

    ut_atomic_u16_write();
    ut_atomic_u16_write_rel();
    ut_atomic_u16_write_rlx();

    ut_atomic_u16_xchg();
    ut_atomic_u16_xchg_acq();
    ut_atomic_u16_xchg_rel();
    ut_atomic_u16_xchg_rlx();

    ut_atomic_u16_cmpxchg();
    ut_atomic_u16_cmpxchg_acq();
    ut_atomic_u16_cmpxchg_rel();
    ut_atomic_u16_cmpxchg_rlx();

    ut_atomic_u16_add();
    ut_atomic_u16_add_rel();
    ut_atomic_u16_add_rlx();
    ut_atomic_u16_get_add();
    ut_atomic_u16_add_get();
    ut_atomic_u16_get_add_acq();
    ut_atomic_u16_add_get_acq();
    ut_atomic_u16_get_add_rel();
    ut_atomic_u16_add_get_rel();
    ut_atomic_u16_get_add_rlx();
    ut_atomic_u16_add_get_rlx();

    ut_atomic_u16_inc();
    ut_atomic_u16_inc_rel();
    ut_atomic_u16_inc_rlx();
    ut_atomic_u16_get_inc();
    ut_atomic_u16_inc_get();
    ut_atomic_u16_get_inc_acq();
    ut_atomic_u16_inc_get_acq();
    ut_atomic_u16_get_inc_rel();
    ut_atomic_u16_inc_get_rel();
    ut_atomic_u16_get_inc_rlx();
    ut_atomic_u16_inc_get_rlx();

    ut_atomic_u16_sub();
    ut_atomic_u16_sub_rel();
    ut_atomic_u16_sub_rlx();
    ut_atomic_u16_get_sub();
    ut_atomic_u16_sub_get();
    ut_atomic_u16_get_sub_acq();
    ut_atomic_u16_sub_get_acq();
    ut_atomic_u16_get_sub_rel();
    ut_atomic_u16_sub_get_rel();
    ut_atomic_u16_get_sub_rlx();
    ut_atomic_u16_sub_get_rlx();

    ut_atomic_u16_dec();
    ut_atomic_u16_dec_rel();
    ut_atomic_u16_dec_rlx();
    ut_atomic_u16_get_dec();
    ut_atomic_u16_dec_get();
    ut_atomic_u16_get_dec_acq();
    ut_atomic_u16_dec_get_acq();
    ut_atomic_u16_get_dec_rel();
    ut_atomic_u16_dec_get_rel();
    ut_atomic_u16_get_dec_rlx();
    ut_atomic_u16_dec_get_rlx();

    ut_atomic_u16_max();
    ut_atomic_u16_max_rel();
    ut_atomic_u16_max_rlx();
    ut_atomic_u16_get_max();
    ut_atomic_u16_max_get();
    ut_atomic_u16_get_max_acq();
    ut_atomic_u16_max_get_acq();
    ut_atomic_u16_get_max_rel();
    ut_atomic_u16_max_get_rel();
    ut_atomic_u16_get_max_rlx();
    ut_atomic_u16_max_get_rlx();

    ut_atomic_u16_and();
    ut_atomic_u16_and_rel();
    ut_atomic_u16_and_rlx();
    ut_atomic_u16_get_and();
    ut_atomic_u16_and_get();
    ut_atomic_u16_get_and_acq();
    ut_atomic_u16_and_get_acq();
    ut_atomic_u16_get_and_rel();
    ut_atomic_u16_and_get_rel();
    ut_atomic_u16_get_and_rlx();
    ut_atomic_u16_and_get_rlx();

    ut_atomic_u16_or();
    ut_atomic_u16_or_rel();
    ut_atomic_u16_or_rlx();
    ut_atomic_u16_get_or();
    ut_atomic_u16_or_get();
    ut_atomic_u16_get_or_acq();
    ut_atomic_u16_or_get_acq();
    ut_atomic_u16_get_or_rel();
    ut_atomic_u16_or_get_rel();
    ut_atomic_u16_get_or_rlx();
    ut_atomic_u16_or_get_rlx();

    ut_atomic_u16_xor();
    ut_atomic_u16_xor_rel();
    ut_atomic_u16_xor_rlx();
    ut_atomic_u16_get_xor();
    ut_atomic_u16_xor_get();
    ut_atomic_u16_get_xor_acq();
    ut_atomic_u16_xor_get_acq();
    ut_atomic_u16_get_xor_rel();
    ut_atomic_u16_xor_get_rel();
    ut_atomic_u16_get_xor_rlx();
    ut_atomic_u16_xor_get_rlx();
    return 0;
}
