/* 
 * This software is provided with no warranty  whatsoever. You may use, modify
 * and redistribute it as long as you give a credit to the original author and
 * provide a link to the original source.
 *
 * $Id: util.h,v 1.3 2025/07/16 21:12:49 alx Exp $
 */

#ifndef UTIL_H
#define UTIL_H

#define SIZE_CS_MAX 32
#define MODE_CS_MAX 12

/* Returns readable size string */
char* get_size_string(unsigned long size, char buffer[SIZE_CS_MAX]);

/* Returns ls style mode string for the mode specified */
char* get_mode_string(mode_t mode, char buf[MODE_CS_MAX]);

/* Same as getcwd but allocates a buffer */
char* get_working_dir(void);

/*
 * Runs an executable file in a separate process with arguments specified.
 * Returns zero on success, errno otherwise.
 */
int spawn_command(const char *cmd, char * const *args, size_t nargs);

#ifdef DEBUG
#define dprintf printf
#else
#define dprintf(...) ((void)0)
#endif

#endif /* UTIL_H */
